/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0003J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0006J\u001e\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0006J&\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010-\u001a\u00020\u00002\n\u0010\u0007\u001a\u00020\b\"\u00020\u0006J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/safframework/utils/NotificationUtil;", "Landroid/content/ContextWrapper;", "base", "Landroid/content/Context;", "(Landroid/content/Context;)V", "defaults", "", "flags", "", "intent", "Landroid/app/PendingIntent;", "mManager", "Landroid/app/NotificationManager;", "manager", "getManager", "()Landroid/app/NotificationManager;", "ongoing", "", "onlyAlertOnce", "pattern", "", "priority", "remoteViews", "Landroid/widget/RemoteViews;", "sound", "Landroid/net/Uri;", "ticker", "", "when", "", "clearNotification", "", "createNotificationChannel", "getNotification", "Landroid/app/Notification;", "title", "content", "icon", "getNotificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "sendNotification", "notifyId", "setContent", "setContentIntent", "setDefaults", "setFlags", "setOngoing", "setOnlyAlertOnce", "setPriority", "setSound", "setTicker", "setVibrate", "setWhen", "Companion", "saf-kotlin-utils_release"})
public final class NotificationUtil
extends ContextWrapper {
    private NotificationManager mManager;
    private int[] flags;
    private boolean ongoing;
    private RemoteViews remoteViews;
    private PendingIntent intent;
    private String ticker;
    private int priority;
    private boolean onlyAlertOnce;
    private long when;
    private Uri sound;
    private int defaults;
    private long[] pattern;
    @NotNull
    private static final String CHANNEL_ID;
    private static final String CHANNEL_NAME;
    public static final Companion Companion;

    @Nullable
    public final NotificationManager getManager() {
        if (this.mManager == null) {
            Object object = this.getSystemService("notification");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            this.mManager = (NotificationManager)object;
        }
        return this.mManager;
    }

    @RequiresApi(value=26)
    private final void createNotificationChannel() {
        NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 3);
        channel.canBypassDnd();
        channel.enableLights(true);
        channel.setLockscreenVisibility(-1);
        channel.setLightColor(-65536);
        channel.canShowBadge();
        channel.enableVibration(true);
        channel.setBypassDnd(true);
        channel.setVibrationPattern(new long[]{100L, 100L, 200L});
        channel.shouldShowLights();
        NotificationManager notificationManager = this.getManager();
        Intrinsics.checkNotNull((Object)notificationManager);
        notificationManager.createNotificationChannel(channel);
    }

    public final void clearNotification() {
        NotificationManager notificationManager = this.getManager();
        Intrinsics.checkNotNull((Object)notificationManager);
        notificationManager.cancelAll();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Notification getNotification(@NotNull String title, @NotNull String content, int icon) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Notification build = null;
        NotificationCompat.Builder builder = this.getNotificationBuilder(title, content, icon);
        Notification notification = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"builder.build()");
        build = notification;
        if (this.flags != null) {
            Intrinsics.checkNotNull((Object)this.flags);
            if (this.flags.length > 0) {
                int n = 0;
                Intrinsics.checkNotNull((Object)this.flags);
                int n2 = this.flags.length;
                while (n < n2) {
                    void a;
                    int n3 = build.flags;
                    Intrinsics.checkNotNull((Object)this.flags);
                    build.flags = n3 | this.flags[a];
                    ++a;
                }
            }
        }
        return build;
    }

    public final void sendNotification(int notifyId, @NotNull String title, @NotNull String content, int icon) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Notification build = this.getNotification(title, content, icon);
        NotificationManager notificationManager = this.getManager();
        Intrinsics.checkNotNull((Object)notificationManager);
        notificationManager.notify(notifyId, build);
    }

    @NotNull
    public final NotificationCompat.Builder getNotificationBuilder(@NotNull String title, @NotNull String content, int icon) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getApplicationContext(), CHANNEL_ID);
        builder.setContentTitle((CharSequence)title);
        builder.setContentText((CharSequence)content);
        builder.setSmallIcon(icon);
        builder.setPriority(this.priority);
        builder.setOnlyAlertOnce(this.onlyAlertOnce);
        builder.setOngoing(this.ongoing);
        if (this.remoteViews != null) {
            builder.setCustomContentView(this.remoteViews);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setCustomContentView(this.remoteViews);
            } else {
                builder.setContent(this.remoteViews);
            }
        }
        if (this.intent != null) {
            builder.setContentIntent(this.intent);
        }
        if (this.ticker != null) {
            String string = this.ticker;
            Intrinsics.checkNotNull((Object)string);
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                builder.setTicker((CharSequence)this.ticker);
            }
        }
        if (this.when != 0L) {
            builder.setWhen(this.when);
        }
        if (this.sound != null) {
            builder.setSound(this.sound);
        }
        if (this.defaults != 0) {
            builder.setDefaults(this.defaults);
        }
        if (this.pattern != null) {
            builder.setVibrate(this.pattern);
        }
        builder.setAutoCancel(true);
        return builder;
    }

    @NotNull
    public final NotificationUtil setOngoing(boolean ongoing) {
        this.ongoing = ongoing;
        return this;
    }

    @NotNull
    public final NotificationUtil setContent(@NotNull RemoteViews remoteViews) {
        Intrinsics.checkNotNullParameter((Object)remoteViews, (String)"remoteViews");
        this.remoteViews = remoteViews;
        return this;
    }

    @NotNull
    public final NotificationUtil setContentIntent(@NotNull PendingIntent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.intent = intent;
        return this;
    }

    @NotNull
    public final NotificationUtil setTicker(@NotNull String ticker) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        this.ticker = ticker;
        return this;
    }

    @NotNull
    public final NotificationUtil setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @NotNull
    public final NotificationUtil setOnlyAlertOnce(boolean onlyAlertOnce) {
        this.onlyAlertOnce = onlyAlertOnce;
        return this;
    }

    @NotNull
    public final NotificationUtil setWhen(long when) {
        this.when = when;
        return this;
    }

    @NotNull
    public final NotificationUtil setSound(@NotNull Uri sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.sound = sound;
        return this;
    }

    @NotNull
    public final NotificationUtil setDefaults(int defaults) {
        this.defaults = defaults;
        return this;
    }

    @NotNull
    public final NotificationUtil setVibrate(@NotNull long[] pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        return this;
    }

    @NotNull
    public final NotificationUtil setFlags(int ... flags) {
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        this.flags = flags;
        return this;
    }

    public NotificationUtil(@NotNull Context base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super(base);
        this.ticker = "";
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel();
        }
    }

    static {
        Companion = new Companion(null);
        CHANNEL_ID = "default";
        CHANNEL_NAME = "default_channel";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/safframework/utils/NotificationUtil$Companion;", "", "()V", "CHANNEL_ID", "", "getCHANNEL_ID", "()Ljava/lang/String;", "CHANNEL_NAME", "saf-kotlin-utils_release"})
    public static final class Companion {
        @NotNull
        public final String getCHANNEL_ID() {
            return CHANNEL_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

