/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.net.Uri;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002<=B\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010#\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020&J$\u0010'\u001a\u00020\u00002\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010)2\u0006\u0010%\u001a\u00020&J\"\u0010*\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010\u00032\b\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020&J$\u0010-\u001a\u00020\u00002\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010)2\u0006\u0010%\u001a\u00020&J\"\u0010.\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010\u00032\b\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020&J\b\u0010/\u001a\u00020\u0003H\u0002J\u0014\u00100\u001a\u0004\u0018\u00010\u00032\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0002J\u0014\u00101\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010%\u001a\u00020\u00032\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00102\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u0003J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\b\u0010+\u001a\u0004\u0018\u00010\u0003J\u0012\u00105\u001a\u00020&2\b\u00106\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u00107\u001a\u00060\u0015R\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00108\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010\u0003J\b\u00109\u001a\u00020\u0003H\u0016J\u0006\u0010:\u001a\u00020;R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR$\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR$\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0016\u001a\u00060\u0015R\u00020\u00002\n\u0010\u0006\u001a\u00060\u0015R\u00020\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\"\u0010!\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\b\u00a8\u0006>"}, d2={"Lcom/safframework/utils/UriParse;", "", "url", "", "charset", "(Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "getCharset", "()Ljava/lang/String;", "encodedPath", "getEncodedPath", "encodedQuery", "getEncodedQuery", "host", "getHost", "path", "getPath", "", "port", "getPort", "()I", "Lcom/safframework/utils/UriParse$LinkedHashEntity;", "queries", "getQueries", "()Lcom/safframework/utils/UriParse$LinkedHashEntity;", "query", "getQuery", "queryMap", "Ljava/util/LinkedHashMap;", "getQueryMap", "()Ljava/util/LinkedHashMap;", "scheme", "getScheme", "userInfo", "getUserInfo", "addPath", "pathAdded", "encode", "", "addQueries", "input", "Ljava/util/HashMap;", "addQuery", "name", "value", "appendQueries", "appendQuery", "createQueryString", "decode", "dropLastSeparator", "getQueryParameter", "getQueryParameters", "", "isUri", "str", "parseQueryString", "removeQuery", "toString", "toUri", "Landroid/net/Uri;", "Companion", "LinkedHashEntity", "saf-kotlin-utils_release"})
public final class UriParse {
    @Nullable
    private String charset;
    @Nullable
    private String scheme;
    @Nullable
    private String host;
    private int port;
    @Nullable
    private String path;
    @NotNull
    private LinkedHashEntity queries;
    @Nullable
    private String userInfo;
    private static final String SEPARATOR = "/";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getCharset() {
        return this.charset;
    }

    @Nullable
    public final String getScheme() {
        String string = this.scheme;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final String getHost() {
        String string = this.host;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getPath() {
        String string = this.path;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getEncodedPath() {
        String string = this.toUri().getEncodedPath();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getQuery() {
        String string = this.toUri().getQuery();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getEncodedQuery() {
        String string = this.toUri().getEncodedQuery();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final LinkedHashMap<String, String> getQueryMap() {
        return this.queries.toMapWithSingleValue();
    }

    @NotNull
    public final LinkedHashEntity getQueries() {
        return this.queries;
    }

    @Nullable
    public final String getUserInfo() {
        return this.userInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final UriParse addPath(@Nullable String pathAdded, boolean encode) {
        int n;
        int n2;
        String pathAddedInner;
        String string = pathAddedInner = pathAdded;
        if (string == null) return this;
        CharSequence charSequence = string;
        boolean bl = false;
        if (!(!StringsKt.isBlank((CharSequence)charSequence))) return this;
        charSequence = pathAddedInner;
        bl = false;
        String pathTemp = pathAddedInner = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        if (StringsKt.startsWith$default((String)pathAddedInner, (String)SEPARATOR, (boolean)false, (int)2, null)) {
            String string2 = pathAddedInner;
            n2 = 1;
            n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            pathTemp = string4;
        }
        if (StringsKt.endsWith$default((String)pathAddedInner, (String)SEPARATOR, (boolean)false, (int)2, null)) {
            String string5 = pathAddedInner;
            n2 = 0;
            n = pathAddedInner.length() - 1;
            boolean bl2 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n2, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            pathTemp = string7;
        }
        if (encode) {
            pathTemp = this.encode(pathTemp);
        }
        if (this.getPath() != null) {
            String string8 = this.getPath();
            if (string8 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.endsWith$default((String)string8, (String)SEPARATOR, (boolean)false, (int)2, null)) {
                this.path = this.getPath() + pathTemp + SEPARATOR;
                return this;
            }
        }
        if (this.getPath() != null) {
            this.path = this.getPath() + SEPARATOR + pathTemp;
            return this;
        }
        this.path = pathTemp;
        return this;
    }

    @NotNull
    public final UriParse addQuery(@Nullable String name, @Nullable String value, boolean encode) {
        block6: {
            block5: {
                CharSequence charSequence = name;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block5;
                charSequence = value;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block6;
            }
            return this;
        }
        if (encode) {
            this.removeQuery(this.encode(name));
            this.queries.putString(this.encode(name), this.encode(value));
        } else {
            this.removeQuery(name);
            this.queries.putString(name, value);
        }
        return this;
    }

    @NotNull
    public final UriParse addQueries(@Nullable HashMap<String, String> input, boolean encode) {
        if (input == null || input.size() == 0) {
            return this;
        }
        if (encode) {
            for (String name : input.keySet()) {
                this.removeQuery(this.encode(name));
                String value = this.encode(input.get(name));
                this.queries.putString(this.encode(name), value);
            }
        } else {
            for (String name : input.keySet()) {
                this.removeQuery(name);
                String value = input.get(name);
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                this.queries.putString(string, value);
            }
        }
        return this;
    }

    @NotNull
    public final UriParse appendQuery(@Nullable String name, @Nullable String value, boolean encode) {
        block6: {
            block5: {
                CharSequence charSequence = name;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block5;
                charSequence = value;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block6;
            }
            return this;
        }
        if (encode) {
            this.queries.putString(this.encode(name), this.encode(value));
        } else {
            this.queries.putString(name, value);
        }
        return this;
    }

    @NotNull
    public final UriParse appendQueries(@Nullable HashMap<String, String> input, boolean encode) {
        if (input == null || input.size() == 0) {
            return this;
        }
        if (encode) {
            for (String name : input.keySet()) {
                String value = this.encode(input.get(name));
                this.queries.putString(this.encode(name), value);
            }
        } else {
            for (String name : input.keySet()) {
                String value = input.get(name);
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                this.queries.putString(string, value);
            }
        }
        return this;
    }

    @NotNull
    public final UriParse removeQuery(@Nullable String name) {
        if (name == null) {
            return this;
        }
        if (this.queries.remove((Object)name) == null) {
            this.queries.remove((Object)this.encode(name));
        }
        return this;
    }

    @NotNull
    public final String getQueryParameter(@Nullable String name) {
        String string = this.toUri().getQueryParameter(name);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final List<String> getQueryParameters(@Nullable String name) {
        List list = this.toUri().getQueryParameters(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"toUri().getQueryParameters(name)");
        return list;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        CharSequence charSequence = this.getScheme();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(this.getScheme()).append("://");
        }
        charSequence = this.userInfo;
        bl = false;
        bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(this.userInfo).append("@");
        }
        charSequence = this.getHost();
        bl = false;
        bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(this.getHost());
        }
        if (this.port != -1) {
            sb.append(":").append(this.port);
        }
        charSequence = this.getPath();
        bl = false;
        bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sb.append(this.getPath());
        }
        String query = this.createQueryString();
        CharSequence charSequence2 = query;
        bl2 = false;
        if (!StringsKt.isBlank((CharSequence)charSequence2)) {
            charSequence2 = query;
            StringBuilder stringBuilder = sb.append("?");
            bl2 = false;
            CharSequence charSequence3 = charSequence2;
            if (charSequence3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string = ((Object)StringsKt.trim((CharSequence)charSequence3)).toString();
            stringBuilder.append(string);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final Uri toUri() {
        Uri uri = Uri.parse((String)this.toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(toString())");
        return uri;
    }

    private final String createQueryString() {
        if (this.queries.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : this.queries.keySet()) {
            List<String> values = this.queries.getValues(name);
            for (String item : values) {
                CharSequence charSequence = sb;
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    sb.append("&");
                }
                sb.append(name).append("=").append(item);
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String encode(String value) {
        if (value != null) {
            try {
                String string;
                if (this.charset == null) {
                    string = value;
                } else {
                    String string2 = URLEncoder.encode(value, this.charset);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLEncoder.encode(value, charset)");
                }
                return string;
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)"Exception", (String)e.getMessage());
            }
        }
        return "";
    }

    private final String decode(String value) {
        if (value != null) {
            try {
                return this.charset == null ? value : URLDecoder.decode(value, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)"Exception", (String)e.getMessage());
            }
        }
        return null;
    }

    private final LinkedHashEntity parseQueryString(String query) {
        LinkedHashEntity params = new LinkedHashEntity();
        CharSequence charSequence = query;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return params;
        }
        CharSequence charSequence2 = query;
        String string = "&";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl3 = false;
        Iterable $this$dropWhile$iv = string.split(charSequence2, n);
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            String it = (String)item$iv;
            boolean bl4 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        List receivedQueryPairs = list$iv;
        for (String queryItem : receivedQueryPairs) {
            String value;
            String name;
            int separator = StringsKt.indexOf$default((CharSequence)queryItem, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (separator == -1) continue;
            String string2 = queryItem;
            int n2 = 0;
            int n3 = 0;
            Object object = string2;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object).substring(n2, separator), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = queryItem;
            n3 = separator + 1;
            boolean bl5 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
            params.putString(name, value);
        }
        return params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUri(String str) {
        String string = str;
        if (string == null) return false;
        CharSequence charSequence = string;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        charSequence = str;
        String string2 = "\\w+://.+";
        boolean bl3 = false;
        string2 = new Regex(string2);
        bl3 = false;
        if (!string2.matches(charSequence)) return false;
        return true;
    }

    private final String dropLastSeparator(String path) {
        String pathVar;
        String string = path;
        if (string == null) {
            return null;
        }
        String string2 = pathVar = string;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.endsWith$default((String)string2, (String)SEPARATOR, (boolean)false, (int)2, null)) {
            String string3 = pathVar;
            int n = 0;
            int n2 = pathVar.length() - 1;
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            pathVar = string4;
        }
        return pathVar;
    }

    @JvmOverloads
    public UriParse(@Nullable String url, @Nullable String charset) {
        this.charset = "utf-8";
        this.port = -1;
        this.queries = new LinkedHashEntity();
        String string = charset;
        if (string != null) {
            CharSequence charSequence = string;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                this.charset = charset;
            }
        }
        if (this.charset != null && !Charset.isSupported(this.charset)) {
            StringBuilder stringBuilder = new StringBuilder().append("charset is not supported:");
            String string2 = this.charset;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        if (this.isUri(url)) {
            URI newUri;
            URI uRI = newUri = URI.create(url);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"newUri");
            this.scheme = uRI.getScheme();
            this.host = newUri.getHost();
            this.port = newUri.getPort();
            this.userInfo = newUri.getUserInfo();
            this.path = this.dropLastSeparator(newUri.getPath());
            this.queries = this.parseQueryString(newUri.getQuery());
        }
    }

    public /* synthetic */ UriParse(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @JvmOverloads
    public UriParse(@Nullable String url) {
        this(url, null, 2, null);
    }

    static {
        SEPARATOR = SEPARATOR;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n0\u0003R\u00060\u0000R\u00020\u00040\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0002J\"\u0010\t\u001a\f\u0018\u00010\u0003R\u00060\u0000R\u00020\u00042\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002J\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u000e"}, d2={"Lcom/safframework/utils/UriParse$LinkedHashEntity;", "Ljava/util/LinkedHashMap;", "", "Lcom/safframework/utils/UriParse$LinkedHashEntity$Entity;", "Lcom/safframework/utils/UriParse;", "(Lcom/safframework/utils/UriParse;)V", "getValues", "", "name", "putString", "key", "value", "toMapWithSingleValue", "Entity", "saf-kotlin-utils_release"})
    public final class LinkedHashEntity
    extends LinkedHashMap<String, Entity> {
        @Nullable
        public final Entity putString(@NotNull String key, @Nullable String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Entity entity = (Entity)this.get((Object)key);
            if (entity != null) {
                entity.add$saf_kotlin_utils_release(value);
                return super.put(key, entity);
            }
            return this.put(key, new Entity(value));
        }

        @NotNull
        public final List<String> getValues(@Nullable String name) {
            LinkedHashEntity linkedHashEntity = this;
            boolean bl = false;
            Entity entity = (Entity)linkedHashEntity.get((Object)name);
            return name != null && entity != null ? entity.getValues$saf_kotlin_utils_release() : (List)new ArrayList();
        }

        @NotNull
        public final LinkedHashMap<String, String> toMapWithSingleValue() {
            boolean bl = false;
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            LinkedHashEntity $this$forEach$iv = this;
            boolean $i$f$forEach = false;
            LinkedHashEntity linkedHashEntity = $this$forEach$iv;
            boolean bl2 = false;
            Iterator iterator = linkedHashEntity.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry item = element$iv = iterator.next();
                boolean bl3 = false;
                ((Map)result).put(item.getKey(), ((Entity)item.getValue()).getValues$saf_kotlin_utils_release().get(0));
            }
            return result;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b\tJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0000\u00a2\u0006\u0002\b\fR\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/safframework/utils/UriParse$LinkedHashEntity$Entity;", "", "value", "", "(Lcom/safframework/utils/UriParse$LinkedHashEntity;Ljava/lang/String;)V", "values", "Ljava/util/LinkedHashSet;", "add", "", "add$saf_kotlin_utils_release", "getValues", "", "getValues$saf_kotlin_utils_release", "saf-kotlin-utils_release"})
        public final class Entity {
            private final LinkedHashSet<String> values = new LinkedHashSet();

            @NotNull
            public final List<String> getValues$saf_kotlin_utils_release() {
                return this.values != null && this.values.iterator().hasNext() ? (List)new ArrayList(this.values) : (List)new ArrayList();
            }

            public final void add$saf_kotlin_utils_release(@Nullable String value) {
                if (value != null) {
                    LinkedHashSet<String> linkedHashSet = this.values;
                    if (linkedHashSet == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!linkedHashSet.contains(UriParse.this.encode(value)) && !CollectionsKt.contains((Iterable)this.values, (Object)UriParse.this.decode(value))) {
                        this.values.add(value);
                    }
                }
            }

            public Entity(String value) {
                if (value != null) {
                    this.values.add(value);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/safframework/utils/UriParse$Companion;", "", "()V", "SEPARATOR", "", "from", "Lcom/safframework/utils/UriParse;", "url", "charset", "saf-kotlin-utils_release"})
    public static final class Companion {
        @NotNull
        public final UriParse from(@Nullable String url, @Nullable String charset) {
            return new UriParse(url, charset);
        }

        public static /* synthetic */ UriParse from$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.from(string, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

