/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.annotation.TargetApi;
import android.os.Environment;
import android.os.StatFs;
import com.safframework.tony.common.utils.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fJ \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/safframework/utils/SDCardUtils;", "", "()V", "GB", "", "getGB", "()I", "KB", "getKB", "MB", "getMB", "byte2FitMemorySize", "", "byteNum", "", "checkSDCardAvailable", "", "deleteSDFile", "filePath", "fileName", "getSDCardFreeSpace", "getSDCardInfo", "Lcom/safframework/utils/SDCardUtils$SDCardInfo;", "getSDCardPath", "isFileExistsInSDCard", "readFileFromSDCard", "", "saveFileToSDCard", "filename", "content", "SDCardInfo", "saf-kotlin-utils_release"})
public final class SDCardUtils {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int GB = 0x40000000;
    public static final SDCardUtils INSTANCE;

    public final int getKB() {
        return KB;
    }

    public final int getMB() {
        return MB;
    }

    public final int getGB() {
        return GB;
    }

    @JvmStatic
    public static final boolean checkSDCardAvailable() {
        return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
    }

    @JvmStatic
    public static final boolean isFileExistsInSDCard(@NotNull String filePath, @NotNull String fileName) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        boolean flag = false;
        if (SDCardUtils.checkSDCardAvailable() && (file = new File(filePath, fileName)).exists()) {
            flag = true;
        }
        return flag;
    }

    @JvmStatic
    public static final boolean saveFileToSDCard(@NotNull String filePath, @NotNull String filename, @NotNull String content) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        boolean flag = false;
        if (SDCardUtils.checkSDCardAvailable()) {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdir();
            }
            File file = new File(filePath, filename);
            FileOutputStream outStream = new FileOutputStream(file);
            String string = content;
            FileOutputStream fileOutputStream = outStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            fileOutputStream.write(byArray2);
            outStream.close();
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] readFileFromSDCard(@NotNull String filePath, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        byte[] buffer = null;
        FileInputStream fin = null;
        try {
            if (SDCardUtils.checkSDCardAvailable()) {
                String filePaht = filePath + "/" + fileName;
                fin = new FileInputStream(filePaht);
                int length = fin.available();
                buffer = new byte[length];
                fin.read(buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)fin);
        }
        return buffer;
    }

    @JvmStatic
    public static final boolean deleteSDFile(@NotNull String filePath, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        File file = new File(filePath + "/" + fileName);
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String getSDCardPath() {
        String string;
        if (!SDCardUtils.checkSDCardAvailable()) {
            string = null;
        } else {
            String command = "car /proc/mounts";
            Runtime runtime = Runtime.getRuntime();
            BufferedReader bufferReader = null;
            try {
                Process p;
                Process process = p = runtime.exec(command);
                Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"p");
                bufferReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = bufferReader.readLine();
                while (line != null) {
                    List strArray;
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"sdcard", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)".android_secure", (boolean)false, (int)2, null) && (strArray = StringsKt.split$default((CharSequence)line, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)).size() >= 5) {
                        String cfr_ignored_0 = StringsKt.replace$default((String)((String)strArray.get(1)), (String)"/.android_secure", (String)"", (boolean)false, (int)4, null) + File.separator;
                    }
                    if (p.waitFor() == 0 || p.exitValue() != 1) continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((Closeable)bufferReader);
            }
            File file = Environment.getExternalStorageDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
            string = file.getPath();
        }
        return string;
    }

    @JvmStatic
    @TargetApi(value=18)
    @Nullable
    public static final String getSDCardFreeSpace() {
        String string;
        if (!SDCardUtils.checkSDCardAvailable()) {
            string = null;
        } else {
            StatFs statFs = new StatFs(SDCardUtils.getSDCardPath());
            string = INSTANCE.byte2FitMemorySize(statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong());
        }
        return string;
    }

    @NotNull
    public final String byte2FitMemorySize(long byteNum) {
        String string;
        if (byteNum < 0L) {
            string = "shouldn't be less than zero";
        } else if (byteNum < (long)KB) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%.3fB";
            Object[] objectArray = new Object[]{(double)byteNum + 5.0E-4};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else if (byteNum < (long)MB) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%.3fKB";
            Object[] objectArray = new Object[]{byteNum / (long)KB};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else if (byteNum < (long)GB) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string6 = "%.3fMB";
            Object[] objectArray = new Object[]{byteNum / (long)MB};
            boolean bl = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string8 = "%.3fGB";
            Object[] objectArray = new Object[]{byteNum / (long)GB};
            boolean bl = false;
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    @JvmStatic
    @TargetApi(value=18)
    @NotNull
    public static final SDCardInfo getSDCardInfo() {
        SDCardInfo sDCardInfo;
        if (!SDCardUtils.checkSDCardAvailable()) {
            sDCardInfo = new SDCardInfo(false, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 255, null);
        } else {
            StatFs statFs = new StatFs(SDCardUtils.getSDCardPath());
            sDCardInfo = new SDCardInfo(true, statFs.getBlockCountLong(), statFs.getFreeBlocksLong(), statFs.getAvailableBlocksLong(), statFs.getBlockSizeLong(), statFs.getTotalBytes(), statFs.getFreeBytes(), statFs.getAvailableBytes());
        }
        return sDCardInfo;
    }

    private SDCardUtils() {
    }

    static {
        SDCardUtils sDCardUtils;
        INSTANCE = sDCardUtils = new SDCardUtils();
        KB = 1024;
        MB = 0x100000;
        GB = 0x40000000;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b&\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003JY\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010\u00a8\u0006/"}, d2={"Lcom/safframework/utils/SDCardUtils$SDCardInfo;", "", "isExist", "", "totalBlocks", "", "freeBlocks", "availableBlocks", "blockByteSize", "totalBytes", "freeBytes", "availableBytes", "(ZJJJJJJJ)V", "getAvailableBlocks", "()J", "setAvailableBlocks", "(J)V", "getAvailableBytes", "setAvailableBytes", "getBlockByteSize", "setBlockByteSize", "getFreeBlocks", "setFreeBlocks", "getFreeBytes", "setFreeBytes", "()Z", "setExist", "(Z)V", "getTotalBlocks", "setTotalBlocks", "getTotalBytes", "setTotalBytes", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "", "saf-kotlin-utils_release"})
    public static final class SDCardInfo {
        private boolean isExist;
        private long totalBlocks;
        private long freeBlocks;
        private long availableBlocks;
        private long blockByteSize;
        private long totalBytes;
        private long freeBytes;
        private long availableBytes;

        public final boolean isExist() {
            return this.isExist;
        }

        public final void setExist(boolean bl) {
            this.isExist = bl;
        }

        public final long getTotalBlocks() {
            return this.totalBlocks;
        }

        public final void setTotalBlocks(long l) {
            this.totalBlocks = l;
        }

        public final long getFreeBlocks() {
            return this.freeBlocks;
        }

        public final void setFreeBlocks(long l) {
            this.freeBlocks = l;
        }

        public final long getAvailableBlocks() {
            return this.availableBlocks;
        }

        public final void setAvailableBlocks(long l) {
            this.availableBlocks = l;
        }

        public final long getBlockByteSize() {
            return this.blockByteSize;
        }

        public final void setBlockByteSize(long l) {
            this.blockByteSize = l;
        }

        public final long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        public final long getFreeBytes() {
            return this.freeBytes;
        }

        public final void setFreeBytes(long l) {
            this.freeBytes = l;
        }

        public final long getAvailableBytes() {
            return this.availableBytes;
        }

        public final void setAvailableBytes(long l) {
            this.availableBytes = l;
        }

        public SDCardInfo(boolean isExist, long totalBlocks, long freeBlocks, long availableBlocks, long blockByteSize, long totalBytes, long freeBytes, long availableBytes) {
            this.isExist = isExist;
            this.totalBlocks = totalBlocks;
            this.freeBlocks = freeBlocks;
            this.availableBlocks = availableBlocks;
            this.blockByteSize = blockByteSize;
            this.totalBytes = totalBytes;
            this.freeBytes = freeBytes;
            this.availableBytes = availableBytes;
        }

        public /* synthetic */ SDCardInfo(boolean bl, long l, long l2, long l3, long l4, long l5, long l6, long l7, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                l = -1L;
            }
            if ((n & 4) != 0) {
                l2 = -1L;
            }
            if ((n & 8) != 0) {
                l3 = -1L;
            }
            if ((n & 0x10) != 0) {
                l4 = -1L;
            }
            if ((n & 0x20) != 0) {
                l5 = -1L;
            }
            if ((n & 0x40) != 0) {
                l6 = -1L;
            }
            if ((n & 0x80) != 0) {
                l7 = -1L;
            }
            this(bl, l, l2, l3, l4, l5, l6, l7);
        }

        public SDCardInfo() {
            this(false, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 255, null);
        }

        public final boolean component1() {
            return this.isExist;
        }

        public final long component2() {
            return this.totalBlocks;
        }

        public final long component3() {
            return this.freeBlocks;
        }

        public final long component4() {
            return this.availableBlocks;
        }

        public final long component5() {
            return this.blockByteSize;
        }

        public final long component6() {
            return this.totalBytes;
        }

        public final long component7() {
            return this.freeBytes;
        }

        public final long component8() {
            return this.availableBytes;
        }

        @NotNull
        public final SDCardInfo copy(boolean isExist, long totalBlocks, long freeBlocks, long availableBlocks, long blockByteSize, long totalBytes, long freeBytes, long availableBytes) {
            return new SDCardInfo(isExist, totalBlocks, freeBlocks, availableBlocks, blockByteSize, totalBytes, freeBytes, availableBytes);
        }

        public static /* synthetic */ SDCardInfo copy$default(SDCardInfo sDCardInfo, boolean bl, long l, long l2, long l3, long l4, long l5, long l6, long l7, int n, Object object) {
            if ((n & 1) != 0) {
                bl = sDCardInfo.isExist;
            }
            if ((n & 2) != 0) {
                l = sDCardInfo.totalBlocks;
            }
            if ((n & 4) != 0) {
                l2 = sDCardInfo.freeBlocks;
            }
            if ((n & 8) != 0) {
                l3 = sDCardInfo.availableBlocks;
            }
            if ((n & 0x10) != 0) {
                l4 = sDCardInfo.blockByteSize;
            }
            if ((n & 0x20) != 0) {
                l5 = sDCardInfo.totalBytes;
            }
            if ((n & 0x40) != 0) {
                l6 = sDCardInfo.freeBytes;
            }
            if ((n & 0x80) != 0) {
                l7 = sDCardInfo.availableBytes;
            }
            return sDCardInfo.copy(bl, l, l2, l3, l4, l5, l6, l7);
        }

        @NotNull
        public String toString() {
            return "SDCardInfo(isExist=" + this.isExist + ", totalBlocks=" + this.totalBlocks + ", freeBlocks=" + this.freeBlocks + ", availableBlocks=" + this.availableBlocks + ", blockByteSize=" + this.blockByteSize + ", totalBytes=" + this.totalBytes + ", freeBytes=" + this.freeBytes + ", availableBytes=" + this.availableBytes + ")";
        }

        public int hashCode() {
            int n = this.isExist ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            long l = this.totalBlocks;
            long l2 = this.freeBlocks;
            long l3 = this.availableBlocks;
            long l4 = this.blockByteSize;
            long l5 = this.totalBytes;
            long l6 = this.freeBytes;
            long l7 = this.availableBytes;
            return ((((((n * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32)) * 31 + (int)(l4 ^ l4 >>> 32)) * 31 + (int)(l5 ^ l5 >>> 32)) * 31 + (int)(l6 ^ l6 >>> 32)) * 31 + (int)(l7 ^ l7 >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SDCardInfo)) break block3;
                    SDCardInfo sDCardInfo = (SDCardInfo)object;
                    if (this.isExist != sDCardInfo.isExist || this.totalBlocks != sDCardInfo.totalBlocks || this.freeBlocks != sDCardInfo.freeBlocks || this.availableBlocks != sDCardInfo.availableBlocks || this.blockByteSize != sDCardInfo.blockByteSize || this.totalBytes != sDCardInfo.totalBytes || this.freeBytes != sDCardInfo.freeBytes || this.availableBytes != sDCardInfo.availableBytes) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

