/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a#\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u000e\u001a\u00020\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010\u00a8\u0006\u0011"}, d2={"checkGPSStatus", "", "context", "Landroid/content/Context;", "checkNetworkStatus", "getMetaData", "T", "name", "", "(Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Object;", "installAPK", "", "fileName", "isWiFiActive", "makeLogTag", "cls", "Ljava/lang/Class;", "saf-kotlin-utils_release"})
public final class SAFUtilsKt {
    public static final boolean isWiFiActive(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        WifiManager wm = null;
        try {
            Object object = context.getSystemService("wifi");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            wm = (WifiManager)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wm != null && wm.isWifiEnabled();
    }

    public static final void installAPK(@NotNull String fileName, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)new File(fileName)), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static final boolean checkNetworkStatus(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean resp = false;
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connMgr = (ConnectivityManager)object;
        NetworkInfo activeNetInfo = connMgr.getActiveNetworkInfo();
        if (activeNetInfo != null && activeNetInfo.isAvailable()) {
            resp = true;
        }
        return resp;
    }

    public static final boolean checkGPSStatus(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean resp = false;
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager lm = (LocationManager)object;
        if (lm.isProviderEnabled("gps")) {
            resp = true;
        }
        return resp;
    }

    @NotNull
    public static final String makeLogTag(@NotNull Class<?> cls) {
        Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
        String string = cls.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cls.simpleName");
        return string;
    }

    @Nullable
    public static final <T> T getMetaData(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return (T)(bundle != null ? bundle.get(name) : null);
        }
        catch (Exception e) {
            String string = "Couldn't find meta-data: " + name;
            boolean bl = false;
            System.out.print((Object)string);
            return null;
        }
    }
}

