/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.safframework.tony.common.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\r"}, d2={"Lcom/safframework/utils/ProcessUtils;", "", "()V", "getAllBackgroundProcesses", "Ljava/util/HashSet;", "", "context", "Landroid/content/Context;", "getForegroundProcessName", "killAllBackgroundProcesses", "killBackgroundProcesses", "", "packageName", "saf-kotlin-utils_release"})
public final class ProcessUtils {
    public static final ProcessUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String getForegroundProcessName(@NotNull Context context) {
        block14: {
            Intent intent;
            PackageManager pm;
            List list;
            Unit unit;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager am = (ActivityManager)object;
            List list2 = am.getRunningAppProcesses();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"am.runningAppProcesses");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (it.importance == 100) {
                    return it.processName;
                }
                unit = Unit.INSTANCE;
                collection.add(unit);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            if (Build.VERSION.SDK_INT <= 21 || (list = (pm = context.getPackageManager()).queryIntentActivities(intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS"), 65536)).size() <= 0) break block14;
            try {
                void $this$mapTo$iv$iv2;
                ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 0);
                Object object2 = context.getSystemService("appops");
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.AppOpsManager");
                }
                AppOpsManager aom = (AppOpsManager)object2;
                if (aom.checkOpNoThrow("android:get_usage_stats", ai.uid, ai.packageName) != 0) {
                    context.startActivity(intent);
                    return null;
                }
                Object object3 = context.getSystemService("usagestats");
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStatsManager");
                }
                UsageStatsManager usm = (UsageStatsManager)object3;
                long endTime = System.currentTimeMillis();
                long beginTime = endTime - (long)604800000;
                List usageStats = usm.queryUsageStats(4, beginTime, endTime);
                if (usageStats == null || usageStats.isEmpty()) {
                    return null;
                }
                UsageStats recentStats = null;
                Iterable $this$map$iv2 = usageStats;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    block16: {
                        void it;
                        block15: {
                            UsageStats usageStats2 = (UsageStats)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl = false;
                            if (recentStats == null) break block15;
                            void v4 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                            UsageStats usageStats3 = recentStats;
                            if (usageStats3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStats");
                            }
                            if (v4.getLastTimeUsed() <= usageStats3.getLastTimeUsed()) break block16;
                        }
                        recentStats = it;
                    }
                    unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_1 = (List)destination$iv$iv2;
                UsageStats usageStats4 = recentStats;
                return usageStats4 != null ? usageStats4.getPackageName() : null;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final HashSet<String> getAllBackgroundProcesses(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        HashSet<String> set = new HashSet<String>();
        List list = am.getRunningAppProcesses();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"am.runningAppProcesses");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Collection collection2 = set;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.pkgList, (String)"it.pkgList");
            Boolean bl2 = CollectionsKt.addAll((Collection)collection2, (Object[])it.pkgList);
            collection.add(bl2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return set;
    }

    @JvmStatic
    @NotNull
    public static final HashSet<String> killAllBackgroundProcesses(@NotNull Context context) {
        List list;
        Boolean bl;
        String it;
        Collection collection;
        String[] $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        String[] $this$map$iv;
        ActivityManager.RunningAppProcessInfo it2;
        Collection collection2;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        HashSet<String> set = new HashSet<String>();
        List list2 = am.getRunningAppProcesses();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"am.runningAppProcesses");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it2.pkgList, (String)"it.pkgList");
            $this$map$iv = it2.pkgList;
            $i$f$map = false;
            String[] stringArray = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            $i$f$mapTo = false;
            for (String item$iv$iv2 : $this$mapTo$iv$iv) {
                void var21_21 = item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                am.killBackgroundProcesses(it);
                bl = set.add(it);
                collection.add(bl);
            }
            list = (List)destination$iv$iv;
            collection2.add(list);
        }
        List cfr_ignored_0 = (List)destination$iv$iv2;
        List list3 = am.getRunningAppProcesses();
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"am.runningAppProcesses");
        $this$map$iv2 = list3;
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl4 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it2.pkgList, (String)"it.pkgList");
            $this$map$iv = it2.pkgList;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            $i$f$mapTo = false;
            String[] stringArray = $this$mapTo$iv$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item$iv$iv2;
                it = item$iv$iv2 = stringArray[i];
                collection = destination$iv$iv;
                boolean bl5 = false;
                bl = set.remove(it);
                collection.add(bl);
            }
            list = (List)destination$iv$iv;
            collection2.add(list);
        }
        List cfr_ignored_1 = (List)destination$iv$iv2;
        return set;
    }

    @JvmStatic
    public static final boolean killBackgroundProcesses(@NotNull Context context, @Nullable String packageName) {
        Unit unit;
        ActivityManager.RunningAppProcessInfo it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Preconditions.isBlank((Object)packageName)) {
            return false;
        }
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List list = am.getRunningAppProcesses();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"am.runningAppProcesses");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.pkgList, (String)"it.pkgList");
            if (ArraysKt.asList((Object[])it.pkgList).contains(packageName)) {
                am.killBackgroundProcesses(packageName);
            }
            unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        List list2 = am.getRunningAppProcesses();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"am.runningAppProcesses");
        $this$map$iv = list2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.pkgList, (String)"it.pkgList");
            if (ArraysKt.toList((Object[])it.pkgList).contains(packageName)) {
                return false;
            }
            unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_1 = (List)destination$iv$iv;
        return true;
    }

    private ProcessUtils() {
    }

    static {
        ProcessUtils processUtils;
        INSTANCE = processUtils = new ProcessUtils();
    }
}

