/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"createOrExistsDir", "", "file", "Ljava/io/File;", "createOrExistsFile", "exists", "isDirectory", "isFile", "saf-kotlin-utils_release"})
public final class FileUtilsKt {
    public static final boolean exists(@Nullable File file) {
        return file != null && file.exists();
    }

    public static final boolean isFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FileUtilsKt.exists(file) && file.isFile();
    }

    public static final boolean isDirectory(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FileUtilsKt.exists(file) && file.isDirectory();
    }

    public static final boolean createOrExistsDir(@Nullable File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static final boolean createOrExistsFile(@Nullable File file) {
        if (file == null || !FileUtilsKt.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

