/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"gc", "", "context", "Landroid/content/Context;", "getCurrentRuntimeValue", "", "getDeviceUsableMemory", "", "getSDKVersion", "isART", "", "isDalvik", "saf-kotlin-utils_release"})
public final class AppUtilsKt {
    public static final int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static final boolean isDalvik() {
        return Intrinsics.areEqual((Object)"Dalvik", (Object)AppUtilsKt.getCurrentRuntimeValue());
    }

    public static final boolean isART() {
        String currentRuntime = AppUtilsKt.getCurrentRuntimeValue();
        return Intrinsics.areEqual((Object)"ART", (Object)currentRuntime) || Intrinsics.areEqual((Object)"ART debug build", (Object)currentRuntime);
    }

    @NotNull
    public static final String getCurrentRuntimeValue() {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            try {
                Method method = systemProperties.getMethod("get", String.class, String.class);
                if (method == null) {
                    return "WTF?!";
                }
                Method get = method;
                try {
                    Object object = get.invoke(systemProperties, "persist.sys.dalvik.vm.lib", "Dalvik");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String value = (String)object;
                    if (Intrinsics.areEqual((Object)"libdvm.so", (Object)value)) {
                        return "Dalvik";
                    }
                    if (Intrinsics.areEqual((Object)"libart.so", (Object)value)) {
                        return "ART";
                    }
                    if (Intrinsics.areEqual((Object)"libartd.so", (Object)value)) {
                        return "ART debug build";
                    }
                    return value;
                }
                catch (IllegalAccessException e) {
                    return "IllegalAccessException";
                }
                catch (IllegalArgumentException e) {
                    return "IllegalArgumentException";
                }
                catch (InvocationTargetException e) {
                    return "InvocationTargetException";
                }
            }
            catch (NoSuchMethodException e) {
                return "SystemProperties.get(String key, String def) method is not found";
            }
        }
        catch (ClassNotFoundException e) {
            return "SystemProperties class is not found";
        }
    }

    public static final long getDeviceUsableMemory(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return mi.availMem / (long)0x100000;
    }

    public static final int gc(@NotNull Context context) {
        List processList;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        long i = AppUtilsKt.getDeviceUsableMemory(context);
        int count = 0;
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List serviceList = am.getRunningServices(100);
        if (serviceList != null) {
            for (ActivityManager.RunningServiceInfo service : serviceList) {
                if (service.pid == Process.myPid()) continue;
                try {
                    Process.killProcess((int)service.pid);
                    ++count;
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        }
        if ((processList = am.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo process : processList) {
                if (process.importance <= 200) continue;
                String[] pkgList = process.pkgList;
                for (int j = 0; j < pkgList.length; ++j) {
                    String pkgName = pkgList[j];
                    Log.d((String)"AppUtils", (String)("======\u6b63\u5728\u6740\u6b7b\u5305\u540d\uff1a" + pkgName));
                    try {
                        am.killBackgroundProcesses(pkgName);
                        ++count;
                        continue;
                    }
                    catch (Exception e) {
                        e.getMessage();
                    }
                }
            }
        }
        Log.d((String)"AppUtils", (String)("\u6e05\u7406\u4e86" + (AppUtilsKt.getDeviceUsableMemory(context) - i) + "M\u5185\u5b58"));
        return count;
    }
}

