/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J%\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000bH\u0007J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000bH\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bH\u0007\u00a8\u0006\u001d"}, d2={"Lcom/safframework/utils/SAFUtils;", "", "()V", "checkGPSStatus", "", "context", "Landroid/content/Context;", "checkNetworkStatus", "dip2px", "", "dpValue", "", "getMetaData", "T", "name", "", "(Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Object;", "installAPK", "", "fileName", "isWiFiActive", "makeLogTag", "cls", "Ljava/lang/Class;", "px2dip", "pxValue", "px2sp", "sp2px", "spValue", "saf-kotlin-utils_release"})
public final class SAFUtils {
    public static final SAFUtils INSTANCE;

    @JvmStatic
    public static final boolean isWiFiActive(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        WifiManager wm = null;
        try {
            Object object = context.getSystemService("wifi");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            wm = (WifiManager)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wm != null && wm.isWifiEnabled();
    }

    @JvmStatic
    public static final void installAPK(@NotNull String fileName, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)new File(fileName)), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    @JvmStatic
    public static final boolean checkNetworkStatus(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean resp = false;
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connMgr = (ConnectivityManager)object;
        NetworkInfo activeNetInfo = connMgr.getActiveNetworkInfo();
        if (activeNetInfo != null && activeNetInfo.isAvailable()) {
            resp = true;
        }
        return resp;
    }

    @JvmStatic
    public static final boolean checkGPSStatus(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean resp = false;
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager lm = (LocationManager)object;
        if (lm.isProviderEnabled("gps")) {
            resp = true;
        }
        return resp;
    }

    @JvmStatic
    @NotNull
    public static final String makeLogTag(@NotNull Class<?> cls) {
        Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
        String string = cls.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cls.simpleName");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final <T> T getMetaData(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return (T)(bundle != null ? bundle.get(name) : null);
        }
        catch (Exception e) {
            String string = "Couldn't find meta-data: " + name;
            System.out.print((Object)string);
            return null;
        }
    }

    @JvmStatic
    public static final int dip2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @JvmStatic
    public static final int px2dip(@NotNull Context context, float pxValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(0.5f + pxValue / scale);
    }

    @JvmStatic
    public static final int sp2px(@NotNull Context context, float spValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(spValue * scale + 0.5f);
    }

    @JvmStatic
    public static final int px2sp(@NotNull Context context, float pxValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private SAFUtils() {
        INSTANCE = this;
    }

    static {
        new SAFUtils();
    }
}

