/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.ext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import com.safframework.ext.AppInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0014\u0010\n\u001a\u00020\u0005*\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u001a\u0014\u0010\f\u001a\u00020\u0005*\u00020\u00022\b\b\u0001\u0010\r\u001a\u00020\u0005\u001a\u0012\u0010\u000e\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u000e\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0014\u001a\n\u0010\u0018\u001a\u00020\u0014*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0014*\u00020\u0002\u001a*\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\b\b\u0001\u0010\u001d\u001a\u00020\u00052\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u0001\u001a\u0012\u0010!\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\"\u001a\u00020\u0005\u001a\u0012\u0010#\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\"\u001a\u00020\u0005\u001a\u0012\u0010$\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010$\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0014\u0010%\u001a\u00020\u0014*\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\u0005\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c7\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0016\u0010\b\u001a\u00020\u0005*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006&"}, d2={"isNetworkAvailable", "", "Landroid/content/Context;", "(Landroid/content/Context;)Z", "screenHeight", "", "getScreenHeight", "(Landroid/content/Context;)I", "screenWidth", "getScreenWidth", "color", "id", "dimen2px", "resource", "dp2px", "value", "", "getAppInfo", "Lcom/safframework/ext/AppInfo;", "apkPath", "", "getAppInfos", "", "apkFolderPath", "getAppVersion", "getAppVersionCode", "getPackageName", "inflateLayout", "Landroid/view/View;", "layoutId", "parent", "Landroid/view/ViewGroup;", "attachToRoot", "px2dp", "px", "px2sp", "sp2px", "string", "saf-kotlin-ext_release"})
public final class Context_ExtensionKt {
    public static final int getScreenWidth(@NotNull Context $this$screenWidth) {
        int $i$f$getScreenWidth = 0;
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"$this$screenWidth");
        Resources resources = $this$screenWidth.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public static final int getScreenHeight(@NotNull Context $this$screenHeight) {
        int $i$f$getScreenHeight = 0;
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"$this$screenHeight");
        Resources resources = $this$screenHeight.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    @SuppressLint(value={"MissingPermission"})
    public static final boolean isNetworkAvailable(@NotNull Context $this$isNetworkAvailable) {
        NetworkInfo activeNetworkInfo;
        int $i$f$isNetworkAvailable = 0;
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkAvailable, (String)"$this$isNetworkAvailable");
        Object object = $this$isNetworkAvailable.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        NetworkInfo networkInfo = activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null ? networkInfo.isConnectedOrConnecting() : false;
    }

    public static final int dp2px(@NotNull Context $this$dp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        float f = value;
        Resources resources = $this$dp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    public static final int dp2px(@NotNull Context $this$dp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        Resources resources = $this$dp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(value * resources.getDisplayMetrics().density);
    }

    public static final int sp2px(@NotNull Context $this$sp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        float f = value;
        Resources resources = $this$sp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().scaledDensity);
    }

    public static final int sp2px(@NotNull Context $this$sp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        Resources resources = $this$sp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(value * resources.getDisplayMetrics().scaledDensity);
    }

    public static final float px2dp(@NotNull Context $this$px2dp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2dp, (String)"$this$px2dp");
        float f = px;
        Resources resources = $this$px2dp.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return f / resources.getDisplayMetrics().density;
    }

    public static final float px2sp(@NotNull Context $this$px2sp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2sp, (String)"$this$px2sp");
        float f = px;
        Resources resources = $this$px2sp.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return f / resources.getDisplayMetrics().scaledDensity;
    }

    public static final int dimen2px(@NotNull Context $this$dimen2px, @DimenRes int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$dimen2px, (String)"$this$dimen2px");
        return $this$dimen2px.getResources().getDimensionPixelSize(resource);
    }

    @NotNull
    public static final String string(@NotNull Context $this$string, @StringRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"$this$string");
        String string = $this$string.getString(id);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(id)");
        return string;
    }

    public static final int color(@NotNull Context $this$color, @ColorRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$color, (String)"$this$color");
        return $this$color.getResources().getColor(id);
    }

    @NotNull
    public static final View inflateLayout(@NotNull Context $this$inflateLayout, @LayoutRes int layoutId, @Nullable ViewGroup parent, boolean attachToRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$inflateLayout, (String)"$this$inflateLayout");
        View view = LayoutInflater.from((Context)$this$inflateLayout).inflate(layoutId, parent, attachToRoot);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"LayoutInflater.from(this\u2026Id, parent, attachToRoot)");
        return view;
    }

    public static /* synthetic */ View inflateLayout$default(Context context, int n, ViewGroup viewGroup, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            viewGroup = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return Context_ExtensionKt.inflateLayout(context, n, viewGroup, bl);
    }

    @NotNull
    public static final String getAppVersion(@NotNull Context $this$getAppVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppVersion, (String)"$this$getAppVersion");
        Context appContext = $this$getAppVersion.getApplicationContext();
        PackageManager manager = appContext.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(appContext.getPackageName(), 0);
            if (info != null) {
                String string = info.versionName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.versionName");
                return string;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static final int getAppVersionCode(@NotNull Context $this$getAppVersionCode) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppVersionCode, (String)"$this$getAppVersionCode");
        Context appContext = $this$getAppVersionCode.getApplicationContext();
        PackageManager manager = appContext.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(appContext.getPackageName(), 0);
            if (info != null) {
                return info.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @NotNull
    public static final String getPackageName(@NotNull Context $this$getPackageName) {
        Intrinsics.checkNotNullParameter((Object)$this$getPackageName, (String)"$this$getPackageName");
        String string = $this$getPackageName.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
        return string;
    }

    @NotNull
    public static final AppInfo getAppInfo(@NotNull Context $this$getAppInfo, @NotNull String apkPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppInfo, (String)"$this$getAppInfo");
        Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
        PackageInfo packageInfo = $this$getAppInfo.getPackageManager().getPackageArchiveInfo(apkPath, 128);
        if (packageInfo == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.pm.PackageInfo");
        }
        PackageInfo packageInfo2 = packageInfo;
        packageInfo2.applicationInfo.sourceDir = apkPath;
        packageInfo2.applicationInfo.publicSourceDir = apkPath;
        String packageName = packageInfo2.packageName;
        String appName = ((Object)$this$getAppInfo.getPackageManager().getApplicationLabel(packageInfo2.applicationInfo)).toString();
        String versionName = packageInfo2.versionName;
        int versionCode = packageInfo2.versionCode;
        Drawable drawable = $this$getAppInfo.getPackageManager().getApplicationIcon(packageInfo2.applicationInfo);
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"packageManager.getApplic\u2026kageInfo.applicationInfo)");
        Drawable icon = drawable;
        String string = packageName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageName");
        String string2 = versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"versionName");
        return new AppInfo(apkPath, string, string2, versionCode, appName, icon);
    }

    @NotNull
    public static final List<AppInfo> getAppInfos(@NotNull Context $this$getAppInfos, @NotNull String apkFolderPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppInfos, (String)"$this$getAppInfos");
        Intrinsics.checkNotNullParameter((Object)apkFolderPath, (String)"apkFolderPath");
        ArrayList<AppInfo> appInfoList = new ArrayList<AppInfo>();
        File[] fileArray = new File(apkFolderPath).listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File file2 = file = fileArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            appInfoList.add(Context_ExtensionKt.getAppInfo($this$getAppInfos, string));
        }
        return appInfoList;
    }
}

