/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.ext;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\b\u001a\u00020\u0001\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0002\u001a*\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\b\b\u0001\u0010\u0014\u001a\u00020\u00012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u00020\r*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u0012\u0010\u001b\u001a\u00020\r*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001\u001a\u0014\u0010\u001d\u001a\u00020\u000f*\u00020\u00022\b\b\u0001\u0010\b\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u001e"}, d2={"screenHeight", "", "Landroid/content/Context;", "getScreenHeight", "(Landroid/content/Context;)I", "screenWidth", "getScreenWidth", "color", "id", "dimen2px", "resource", "dp2px", "value", "", "getAppVersion", "", "getAppVersionCode", "getPackageName", "inflateLayout", "Landroid/view/View;", "layoutId", "parent", "Landroid/view/ViewGroup;", "attachToRoot", "", "px2dp", "px", "px2sp", "sp2px", "string", "saf-kotlin-ext_release"})
public final class Context_ExtensionKt {
    public static final int getScreenWidth(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public static final int getScreenHeight(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    public static final int dp2px(@NotNull Context $receiver, int value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        float f = value;
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    public static final int dp2px(@NotNull Context $receiver, float value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)(value * resources.getDisplayMetrics().density);
    }

    public static final int sp2px(@NotNull Context $receiver, int value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        float f = value;
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().scaledDensity);
    }

    public static final int sp2px(@NotNull Context $receiver, float value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)(value * resources.getDisplayMetrics().scaledDensity);
    }

    public static final float px2dp(@NotNull Context $receiver, int px) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        float f = px;
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return f / resources.getDisplayMetrics().density;
    }

    public static final float px2sp(@NotNull Context $receiver, int px) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        float f = px;
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return f / resources.getDisplayMetrics().scaledDensity;
    }

    public static final int dimen2px(@NotNull Context $receiver, @DimenRes int resource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getResources().getDimensionPixelSize(resource);
    }

    @NotNull
    public static final String string(@NotNull Context $receiver, @StringRes int id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getString(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getString(id)");
        return string;
    }

    public static final int color(@NotNull Context $receiver, @ColorRes int id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getResources().getColor(id);
    }

    @NotNull
    public static final View inflateLayout(@NotNull Context $receiver, @LayoutRes int layoutId, @Nullable ViewGroup parent, boolean attachToRoot) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        View view = LayoutInflater.from((Context)$receiver).inflate(layoutId, parent, attachToRoot);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"LayoutInflater.from(this\u2026Id, parent, attachToRoot)");
        return view;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ View inflateLayout$default(Context context, int n, ViewGroup viewGroup, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            viewGroup = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return Context_ExtensionKt.inflateLayout(context, n, viewGroup, bl);
    }

    @NotNull
    public static final String getAppVersion(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Context appContext = $receiver.getApplicationContext();
        PackageManager manager = appContext.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(appContext.getPackageName(), 0);
            if (info != null) {
                String string = info.versionName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"info.versionName");
                return string;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static final int getAppVersionCode(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Context appContext = $receiver.getApplicationContext();
        PackageManager manager = appContext.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(appContext.getPackageName(), 0);
            if (info != null) {
                return info.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @NotNull
    public static final String getPackageName(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageName");
        return string;
    }
}

