/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.ext;

import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u000b"}, d2={"isGone", "", "Landroid/view/View;", "(Landroid/view/View;)Z", "isInvisible", "isVisible", "hideKeyboard", "", "showKeyboard", "toBitmap", "Landroid/graphics/Bitmap;", "saf-kotlin-ext_release"})
public final class ViewsKt {
    public static final boolean isVisible(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 0;
    }

    public static final boolean isInvisible(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 4;
    }

    public static final boolean isGone(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getVisibility() == 8;
    }

    public static final void hideKeyboard(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.clearFocus();
        Object object = $receiver.getContext().getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        ((InputMethodManager)object).hideSoftInputFromWindow($receiver.getWindowToken(), 0);
    }

    public static final void showKeyboard(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.requestFocus();
        Object object = $receiver.getContext().getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        ((InputMethodManager)object).showSoftInput($receiver, 1);
    }

    @Nullable
    public static final Bitmap toBitmap(@NotNull View $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.clearFocus();
        $receiver.setPressed(false);
        boolean willNotCache = $receiver.willNotCacheDrawing();
        $receiver.setWillNotCacheDrawing(false);
        int color = $receiver.getDrawingCacheBackgroundColor();
        $receiver.setDrawingCacheBackgroundColor(0);
        if (color != 0) {
            $receiver.destroyDrawingCache();
        }
        $receiver.buildDrawingCache();
        Bitmap cacheBitmap = $receiver.getDrawingCache();
        if (cacheBitmap == null) {
            Log.e((String)"Views", (String)("failed to get bitmap from " + $receiver), (Throwable)new RuntimeException());
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)cacheBitmap);
        $receiver.destroyDrawingCache();
        $receiver.setWillNotCacheDrawing(willNotCache);
        $receiver.setDrawingCacheBackgroundColor(color);
        return bitmap;
    }
}

