/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.server.converter.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ#\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/safframework/server/converter/gson/GsonUtils;", "", "()V", "gson", "Lcom/google/gson/Gson;", "fromJson", "T", "jsonElement", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "json", "", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "toJson", "data", "gson_release"})
public final class GsonUtils {
    private static Gson gson;
    public static final GsonUtils INSTANCE;

    @JvmStatic
    public static final <T> T fromJson(@NotNull String json, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return (T)gson.fromJson(json, type);
    }

    @JvmStatic
    public static final <T> T fromJson(@NotNull JsonElement jsonElement, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)jsonElement, (String)"jsonElement");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return (T)gson.fromJson(jsonElement, type);
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = gson.toJson(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(data)");
        return string;
    }

    private GsonUtils() {
    }

    static {
        GsonUtils gsonUtils;
        INSTANCE = gsonUtils = new GsonUtils();
        gson = new Gson();
    }
}

