/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import com.safframework.aop.PermissionActivity;
import com.safframework.aop.annotation.Permission;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class PermissionAspect {
    private static final String POINTCUT_METHOD = "execution(@com.safframework.aop.annotation.Permission * *(..))";

    @Pointcut(value="execution(@com.safframework.aop.annotation.Permission * *(..))")
    public void methodAnnotatedWithPermission() {
    }

    @Around(value="methodAnnotatedWithPermission()")
    public Object permissionMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Permission permission = method.getAnnotation(Permission.class);
        String[] permissions = permission.value();
        int requestCode = permission.requestCode();
        Object object = joinPoint.getThis();
        Activity context = null;
        if (object instanceof Activity) {
            context = (Activity)object;
        } else if (object instanceof FragmentActivity) {
            context = (FragmentActivity)object;
        } else if (object instanceof Fragment) {
            context = ((Fragment)object).getContext();
        } else if (object instanceof Service) {
            context = (Service)object;
        }
        Object o = null;
        if (this.checkPermissions((Context)context, permissions)) {
            o = joinPoint.proceed();
        } else {
            Intent intent = new Intent();
            intent.setClass((Context)context, PermissionActivity.class);
            intent.putExtra("permissions", permissions);
            intent.putExtra("requestcode", requestCode);
            context.startActivity(intent);
        }
        return o;
    }

    private boolean checkPermission(Context context, String permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    private boolean checkPermissions(Context context, String[] permissions) {
        for (String permission : permissions) {
            if (this.checkPermission(context, permission)) continue;
            return false;
        }
        return true;
    }
}

