/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.safframework.aop.R;
import java.util.ArrayList;

public class PermissionActivity
extends Activity {
    private String[] permissions;
    private int requestCode;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.permissions = intent.getStringArrayExtra("permissions");
        this.requestCode = intent.getIntExtra("requestcode", 0);
        this.setContentView(R.layout.activity_permission);
        if (this.permissions != null && this.permissions.length > 0) {
            this.requestPermission(this.permissions);
        }
    }

    private void requestPermission(String[] permissions) {
        ArrayList<String> failure = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission) == 0) continue;
            failure.add(permission);
        }
        if (failure.size() == 0) {
            this.requestPermissionSuccess();
            return;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])failure.toArray(new String[0]), (int)this.requestCode);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == this.requestCode) {
            if (grantResults[0] == 0) {
                this.requestPermissionSuccess();
            } else {
                boolean alwaysHidePermission = false;
                for (int i = 0; i < grantResults.length; ++i) {
                    boolean showRequestPermission;
                    if (grantResults[i] == 0 || (showRequestPermission = ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permissions[i]))) continue;
                    alwaysHidePermission = true;
                }
                this.requestPermissionFailed();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void requestPermissionSuccess() {
        this.setResult(-1);
        this.finish();
    }

    private void requestPermissionFailed() {
        this.setResult(0);
        this.finish();
    }
}

