/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import com.safframework.aop.annotation.Safe;
import com.safframework.log.L;
import com.safframework.tony.common.reflect.Reflect;
import com.safframework.tony.common.reflect.ReflectException;
import com.safframework.tony.common.utils.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class SafeAspect {
    private static final String POINTCUT_METHOD = "execution(@com.safframework.aop.annotation.Safe * *(..))";

    @Pointcut(value="execution(@com.safframework.aop.annotation.Safe * *(..))")
    public void methodAnnotatedWithSafe() {
    }

    @Around(value="methodAnnotatedWithSafe()")
    public Object safeMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        block4: {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Safe safe = method.getAnnotation(Safe.class);
            result = null;
            try {
                result = joinPoint.proceed();
            }
            catch (Throwable e) {
                L.w((String)SafeAspect.getStringFromException(e));
                String callBack = safe.callBack();
                if (!Preconditions.isNotBlank((Object)callBack)) break block4;
                try {
                    Reflect.on((Object)joinPoint.getTarget()).call(callBack);
                }
                catch (ReflectException exception) {
                    exception.printStackTrace();
                    L.e((String)("no method " + callBack));
                }
            }
        }
        return result;
    }

    private static String getStringFromException(Throwable ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }
}

