/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import com.safframework.log.L;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class LogMethodAspect {
    @Around(value="execution(!synthetic * *(..)) && onLogMethod()")
    public Object doLogMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logMethod(joinPoint);
    }

    @Pointcut(value="@within(com.safframework.aop.annotation.LogMethod)||@annotation(com.safframework.aop.annotation.LogMethod)")
    public void onLogMethod() {
    }

    private Object logMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        L.w((String)(joinPoint.getSignature().toShortString() + " Args : " + (joinPoint.getArgs() != null ? Arrays.deepToString(joinPoint.getArgs()) : "")));
        Object result = joinPoint.proceed();
        String type = ((MethodSignature)joinPoint.getSignature()).getReturnType().toString();
        L.w((String)(joinPoint.getSignature().toShortString() + " Result : " + ("void".equalsIgnoreCase(type) ? "void" : result)));
        return result;
    }
}

