/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import android.content.Context;
import com.safframework.aop.Utils;
import com.safframework.aop.annotation.Prefs;
import com.safframework.prefs.AppPrefs;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class PrefsAspect {
    @Around(value="execution(!synthetic * *(..)) && onPrefsMethod()")
    public Object doPrefsMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.prefsMethod(joinPoint);
    }

    @Pointcut(value="@within(com.safframework.aop.annotation.Prefs)||@annotation(com.safframework.aop.annotation.Prefs)")
    public void onPrefsMethod() {
    }

    private Object prefsMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Prefs prefs = method.getAnnotation(Prefs.class);
        Object result = null;
        if (prefs != null) {
            String key = prefs.key();
            result = joinPoint.proceed();
            String type = ((MethodSignature)joinPoint.getSignature()).getReturnType().toString();
            if (!"void".equalsIgnoreCase(type)) {
                String className = ((MethodSignature)joinPoint.getSignature()).getReturnType().getCanonicalName();
                AppPrefs appPrefs = AppPrefs.get((Context)Utils.getContext());
                if ("int".equals(className) || "java.lang.Integer".equals(className)) {
                    appPrefs.putInt(key, ((Integer)result).intValue());
                } else if ("boolean".equals(className) || "java.lang.Boolean".equals(className)) {
                    appPrefs.putBoolean(key, ((Boolean)result).booleanValue());
                } else if ("float".equals(className) || "java.lang.Float".equals(className)) {
                    appPrefs.putFloat(key, ((Float)result).floatValue());
                } else if ("long".equals(className) || "java.lang.Long".equals(className)) {
                    appPrefs.putLong(key, ((Long)result).longValue());
                } else if ("java.lang.String".equals(className)) {
                    appPrefs.putString(key, (String)result);
                } else {
                    appPrefs.putObject(key, result);
                }
            }
        } else {
            result = joinPoint.proceed();
        }
        return result;
    }
}

