/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import com.safframework.aop.StopWatch;
import com.safframework.log.L;
import com.safframework.tony.common.utils.Preconditions;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class TraceAspect {
    private static final String POINTCUT_METHOD = "execution(@com.safframework.aop.annotation.Trace * *(..))";
    private static final String POINTCUT_CONSTRUCTOR = "execution(@com.safframework.aop.annotation.Trace *.new(..))";

    @Pointcut(value="execution(@com.safframework.aop.annotation.Trace * *(..))")
    public void methodAnnotatedWithTrace() {
    }

    @Pointcut(value="execution(@com.safframework.aop.annotation.Trace *.new(..))")
    public void constructorAnnotatedTrace() {
    }

    @Around(value="methodAnnotatedWithTrace() || constructorAnnotatedTrace()")
    public Object traceMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String className = methodSignature.getDeclaringType().getSimpleName();
        String methodName = methodSignature.getName();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Object result = joinPoint.proceed();
        stopWatch.stop();
        if (Preconditions.isBlank((Object)className)) {
            className = "Anonymous class";
        }
        L.i((String)className, (String)TraceAspect.buildLogMessage(methodName, stopWatch.getTotalTimeMillis()));
        return result;
    }

    private static String buildLogMessage(String methodName, long methodDuration) {
        StringBuilder message = new StringBuilder();
        message.append(methodName);
        message.append("()");
        message.append(" take ");
        message.append("[");
        message.append(methodDuration);
        message.append("ms");
        message.append("]");
        return message.toString();
    }
}

