/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import com.safframework.aop.annotation.HookMethod;
import com.safframework.log.L;
import com.safframework.tony.common.reflect.Reflect;
import com.safframework.tony.common.reflect.ReflectException;
import com.safframework.tony.common.utils.Preconditions;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class HookMethodAspect {
    @Around(value="execution(!synthetic * *(..)) && onHookMethod()")
    public void doHookMethodd(ProceedingJoinPoint joinPoint) throws Throwable {
        this.hookMethod(joinPoint);
    }

    @Pointcut(value="@within(com.safframework.aop.annotation.HookMethod)||@annotation(com.safframework.aop.annotation.HookMethod)")
    public void onHookMethod() {
    }

    private void hookMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        HookMethod hookMethod = method.getAnnotation(HookMethod.class);
        if (hookMethod == null) {
            return;
        }
        String beforeMethod = hookMethod.beforeMethod();
        String afterMethod = hookMethod.afterMethod();
        if (Preconditions.isNotBlank((Object)beforeMethod)) {
            try {
                Reflect.on((Object)joinPoint.getTarget()).call(beforeMethod);
            }
            catch (ReflectException e) {
                e.printStackTrace();
                L.e((String)("no method " + beforeMethod));
            }
        }
        joinPoint.proceed();
        if (Preconditions.isNotBlank((Object)afterMethod)) {
            try {
                Reflect.on((Object)joinPoint.getTarget()).call(afterMethod);
            }
            catch (ReflectException e) {
                e.printStackTrace();
                L.e((String)("no method " + afterMethod));
            }
        }
    }
}

