/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import android.annotation.TargetApi;
import android.content.Context;
import com.safframework.aop.Utils;
import com.safframework.aop.annotation.Cacheable;
import com.safframework.cache.Cache;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@TargetApi(value=14)
public class CacheAspect {
    @Around(value="execution(!synthetic * *(..)) && onCacheMethod()")
    public Object doCacheMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.cacheMethod(joinPoint);
    }

    @Pointcut(value="@within(com.safframework.aop.annotation.Cacheable)||@annotation(com.safframework.aop.annotation.Cacheable)")
    public void onCacheMethod() {
    }

    private Object cacheMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Cacheable cacheable = method.getAnnotation(Cacheable.class);
        Object result = null;
        if (cacheable != null) {
            String key = cacheable.key();
            int expiry = cacheable.expiry();
            result = joinPoint.proceed();
            Cache cache = Cache.get((Context)Utils.getContext());
            if (expiry > 0) {
                cache.put(key, (Serializable)result, expiry);
            } else {
                cache.put(key, (Serializable)result);
            }
        } else {
            result = joinPoint.proceed();
        }
        return result;
    }
}

