/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.aop;

import android.os.Looper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

@Aspect
public class AsyncAspect {
    @Around(value="execution(!synthetic * *(..)) && onAsyncMethod()")
    public void doAsyncMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        this.asyncMethod(joinPoint);
    }

    @Pointcut(value="@within(com.safframework.aop.annotation.Async)||@annotation(com.safframework.aop.annotation.Async)")
    public void onAsyncMethod() {
    }

    private void asyncMethod(final ProceedingJoinPoint joinPoint) throws Throwable {
        Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Object>(){

            public void call(Subscriber<? super Object> subscriber) {
                Looper.prepare();
                try {
                    joinPoint.proceed();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                Looper.loop();
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe();
    }
}

