/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.http.interceptor;

import com.safframework.http.interceptor.Logger;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/safframework/http/interceptor/LoggingInterceptor;", "Lokhttp3/Interceptor;", "builder", "Lcom/safframework/http/interceptor/LoggingInterceptor$Builder;", "(Lcom/safframework/http/interceptor/LoggingInterceptor$Builder;)V", "charset", "Ljava/nio/charset/Charset;", "isDebug", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "subtypeIsNotFile", "subtype", "", "Builder", "LogLevel", "lib_release"})
public final class LoggingInterceptor
implements Interceptor {
    private final boolean isDebug;
    private final Charset charset;
    private final Builder builder;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        if (this.builder.getHeaders$lib_release().size() > 0) {
            Headers headers = request.headers();
            Set names = headers.names();
            Iterator iterator = names.iterator();
            Request.Builder requestBuilder = request.newBuilder();
            requestBuilder.headers(this.builder.getHeaders$lib_release());
            while (iterator.hasNext()) {
                String string;
                String name = (String)iterator.next();
                if (headers.get(name) == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                requestBuilder.addHeader(name, it);
            }
            request = requestBuilder.build();
        }
        if (!this.isDebug) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        MediaType rContentType = null;
        if (requestBody != null) {
            rContentType = requestBody.contentType();
        }
        String rSubtype = null;
        if (rContentType != null) {
            rSubtype = rContentType.subtype();
        }
        if (this.builder.getRequestFlag()) {
            if (Intrinsics.areEqual((Object)request.method(), (Object)"GET")) {
                Logger.Companion.printJsonRequest(this.builder, request);
            } else if (this.subtypeIsNotFile(rSubtype)) {
                Logger.Companion.printJsonRequest(this.builder, request);
            } else {
                Logger.Companion.printFileRequest(this.builder, request);
            }
        }
        long st = System.nanoTime();
        Response response = chain.proceed(request);
        if (this.builder.getResponseFlag()) {
            ResponseBody responseBody;
            List segmentList = request.url().encodedPathSegments();
            long chainMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - st);
            String header = response.headers().toString();
            int code = response.code();
            boolean isSuccessful = response.isSuccessful();
            ResponseBody responseBody2 = responseBody = response.body();
            MediaType contentType = responseBody2 != null ? responseBody2.contentType() : null;
            String subtype = null;
            if (contentType != null) {
                subtype = contentType.subtype();
            }
            if (this.subtypeIsNotFile(subtype)) {
                ResponseBody responseBody3 = responseBody;
                if (responseBody3 != null) {
                    ResponseBody responseBody4 = responseBody3;
                    boolean bl = false;
                    boolean bl4 = false;
                    ResponseBody it = responseBody4;
                    boolean bl5 = false;
                    BufferedSource source = it.source();
                    source.request(Long.MAX_VALUE);
                    Buffer buffer = source.getBuffer();
                    String bodyString = Logger.Companion.getJsonString(buffer.clone().readString(this.charset));
                    Logger.Companion.printJsonResponse(this.builder, chainMs, isSuccessful, code, header, bodyString, segmentList);
                }
            } else {
                Logger.Companion.printFileResponse(this.builder, chainMs, isSuccessful, code, header, segmentList);
            }
        }
        return response;
    }

    private final boolean subtypeIsNotFile(String subtype) {
        return subtype != null && (StringsKt.contains$default((CharSequence)subtype, (CharSequence)"json", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"xml", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"plain", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"html", (boolean)false, (int)2, null));
    }

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.isDebug = this.builder.isDebug();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        this.charset = charset;
    }

    public /* synthetic */ LoggingInterceptor(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/safframework/http/interceptor/LoggingInterceptor$LogLevel;", "", "(Ljava/lang/String;I)V", "ERROR", "WARN", "INFO", "DEBUG", "lib_release"})
    public static final class LogLevel
    extends Enum<LogLevel> {
        public static final /* enum */ LogLevel ERROR;
        public static final /* enum */ LogLevel WARN;
        public static final /* enum */ LogLevel INFO;
        public static final /* enum */ LogLevel DEBUG;
        private static final /* synthetic */ LogLevel[] $VALUES;

        static {
            LogLevel[] logLevelArray = new LogLevel[4];
            LogLevel[] logLevelArray2 = logLevelArray;
            logLevelArray[0] = ERROR = new LogLevel();
            logLevelArray[1] = WARN = new LogLevel();
            logLevelArray[2] = INFO = new LogLevel();
            logLevelArray[3] = DEBUG = new LogLevel();
            $VALUES = logLevelArray;
        }

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String string) {
            return Enum.valueOf(LogLevel.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004J\u0006\u0010+\u001a\u00020,J\u0015\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b/J\u0006\u00100\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\fJ\u0006\u00104\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0004J\u0006\u00106\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0004J\u000e\u00105\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010\u0010R\u0010\u0010#\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010\u0010R\u0010\u0010'\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/safframework/http/interceptor/LoggingInterceptor$Builder;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "builder", "Lokhttp3/Headers$Builder;", "enableThreadName", "", "getEnableThreadName", "()Z", "setEnableThreadName", "(Z)V", "headers", "Lokhttp3/Headers;", "getHeaders$lib_release", "()Lokhttp3/Headers;", "hideVerticalLineFlag", "getHideVerticalLineFlag", "setHideVerticalLineFlag", "isDebug", "setDebug", "logLevel", "Lcom/safframework/http/interceptor/LoggingInterceptor$LogLevel;", "getLogLevel", "()Lcom/safframework/http/interceptor/LoggingInterceptor$LogLevel;", "setLogLevel", "(Lcom/safframework/http/interceptor/LoggingInterceptor$LogLevel;)V", "requestFlag", "getRequestFlag", "setRequestFlag", "requestTag", "responseFlag", "getResponseFlag", "setResponseFlag", "responseTag", "addHeader", "name", "value", "build", "Lcom/safframework/http/interceptor/LoggingInterceptor;", "getTag", "isRequest", "getTag$lib_release", "hideVerticalLine", "loggable", "printThreadName", "enable", "request", "tag", "response", "lib_release"})
    public static final class Builder {
        @NotNull
        private String TAG = "SAF_Logging_Interceptor";
        private boolean isDebug;
        private boolean enableThreadName = true;
        private boolean requestFlag;
        private boolean responseFlag;
        private boolean hideVerticalLineFlag;
        @NotNull
        private LogLevel logLevel = LogLevel.INFO;
        private String requestTag;
        private String responseTag;
        private final Headers.Builder builder = new Headers.Builder();

        @NotNull
        public final String getTAG() {
            return this.TAG;
        }

        public final void setTAG(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.TAG = string;
        }

        public final boolean isDebug() {
            return this.isDebug;
        }

        public final void setDebug(boolean bl) {
            this.isDebug = bl;
        }

        public final boolean getEnableThreadName() {
            return this.enableThreadName;
        }

        public final void setEnableThreadName(boolean bl) {
            this.enableThreadName = bl;
        }

        public final boolean getRequestFlag() {
            return this.requestFlag;
        }

        public final void setRequestFlag(boolean bl) {
            this.requestFlag = bl;
        }

        public final boolean getResponseFlag() {
            return this.responseFlag;
        }

        public final void setResponseFlag(boolean bl) {
            this.responseFlag = bl;
        }

        public final boolean getHideVerticalLineFlag() {
            return this.hideVerticalLineFlag;
        }

        public final void setHideVerticalLineFlag(boolean bl) {
            this.hideVerticalLineFlag = bl;
        }

        @NotNull
        public final LogLevel getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)logLevel), (String)"<set-?>");
            this.logLevel = logLevel;
        }

        @NotNull
        public final Headers getHeaders$lib_release() {
            return this.builder.build();
        }

        @NotNull
        public final String getTag$lib_release(boolean isRequest) {
            String string;
            if (isRequest) {
                String string2;
                CharSequence charSequence = this.requestTag;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    string2 = this.TAG;
                } else {
                    string2 = this.requestTag;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                }
                return string2;
            }
            CharSequence charSequence = this.responseTag;
            boolean bl = false;
            boolean bl3 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                string = this.TAG;
            } else {
                string = this.responseTag;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            }
            return string;
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.builder.set(name, value);
            return this;
        }

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.TAG = tag;
            return this;
        }

        @NotNull
        public final Builder requestTag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.requestTag = tag;
            return this;
        }

        @NotNull
        public final Builder responseTag(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.responseTag = tag;
            return this;
        }

        @NotNull
        public final Builder request() {
            this.requestFlag = true;
            return this;
        }

        @NotNull
        public final Builder response() {
            this.responseFlag = true;
            return this;
        }

        @NotNull
        public final Builder hideVerticalLine() {
            this.hideVerticalLineFlag = true;
            return this;
        }

        @NotNull
        public final Builder logLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)logLevel), (String)"logLevel");
            this.logLevel = logLevel;
            return this;
        }

        @NotNull
        public final Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        @NotNull
        public final Builder printThreadName(boolean enable) {
            this.enableThreadName = enable;
            return this;
        }

        @NotNull
        public final LoggingInterceptor build() {
            return new LoggingInterceptor(this, null);
        }
    }
}

