/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.log.handler;

import android.os.Bundle;
import com.alibaba.fastjson.JSON;
import com.safframework.log.L;
import com.safframework.log.LoggerPrinter;
import com.safframework.log.handler.BaseHandler;
import com.safframework.log.parser.Parser;
import com.safframework.log.utils.Utils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lcom/safframework/log/handler/BundleHandler;", "Lcom/safframework/log/handler/BaseHandler;", "Lcom/safframework/log/parser/Parser;", "Landroid/os/Bundle;", "()V", "handle", "", "obj", "", "parseString", "", "bundle", "saf-log_release"})
public final class BundleHandler
extends BaseHandler
implements Parser<Bundle> {
    @Override
    protected boolean handle(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (obj instanceof Bundle) {
            String s = L.getMethodNames();
            Object object = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{this.parseString((Bundle)obj)};
            String string = String.format(s, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            object = string;
            System.out.println(object);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String parseString(@NotNull Bundle bundle) {
        String message;
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        String msg = bundle.getClass().toString() + LoggerPrinter.INSTANCE.getBR() + "\u2551 ";
        JSONObject jsonObject = new JSONObject();
        for (String key : bundle.keySet()) {
            boolean isPrimitiveType = Utils.isPrimitiveType(bundle.get(key));
            try {
                if (isPrimitiveType) {
                    jsonObject.put(key.toString(), bundle.get(key));
                    continue;
                }
                jsonObject.put(key.toString(), (Object)new JSONObject(JSON.toJSONString((Object)bundle.get(key))));
            }
            catch (JSONException e) {
                L.e("Invalid Json");
            }
        }
        String string = message = jsonObject.toString(LoggerPrinter.INSTANCE.getJSON_INDENT());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        CharSequence charSequence = string;
        String string2 = "\n";
        string2 = new Regex(string2);
        String string3 = "\n\u2551 ";
        message = string2.replace(charSequence, string3);
        return msg + message;
    }
}

