/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.log.handler;

import android.content.Intent;
import android.os.Bundle;
import com.alibaba.fastjson.JSON;
import com.safframework.log.L;
import com.safframework.log.LoggerPrinter;
import com.safframework.log.handler.BaseHandler;
import com.safframework.log.parser.Parser;
import com.safframework.log.utils.Utils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/safframework/log/handler/IntentHandler;", "Lcom/safframework/log/handler/BaseHandler;", "Lcom/safframework/log/parser/Parser;", "Landroid/content/Intent;", "()V", "handle", "", "obj", "", "parseBundleString", "", "extras", "Landroid/os/Bundle;", "parseString", "intent", "saf-log_release"})
public final class IntentHandler
extends BaseHandler
implements Parser<Intent> {
    @Override
    protected boolean handle(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (obj instanceof Intent) {
            String s = L.getMethodNames();
            Object object = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{this.parseString((Intent)obj)};
            String string = String.format(s, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            object = string;
            System.out.println(object);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String parseString(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        String msg = intent.getClass().toString() + LoggerPrinter.INSTANCE.getBR() + "\u2551 ";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Scheme", (Object)intent.getScheme());
        jsonObject.put("Action", (Object)intent.getAction());
        jsonObject.put("DataString", (Object)intent.getDataString());
        jsonObject.put("Type", (Object)intent.getType());
        jsonObject.put("Package", (Object)intent.getPackage());
        jsonObject.put("ComponentInfo", (Object)intent.getComponent());
        jsonObject.put("Categories", (Object)intent.getCategories());
        if (intent.getExtras() != null) {
            Bundle bundle = intent.getExtras();
            Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"intent.extras");
            jsonObject.put("Extras", (Object)new JSONObject(this.parseBundleString(bundle)));
        }
        String message = jsonObject.toString(LoggerPrinter.INSTANCE.getJSON_INDENT());
        CharSequence charSequence = message;
        String string = "\n";
        string = new Regex(string);
        String string2 = "\n\u2551 ";
        message = string.replace(charSequence, string2);
        return msg + message;
    }

    private final String parseBundleString(Bundle extras) {
        JSONObject jsonObject = new JSONObject();
        for (String key : extras.keySet()) {
            boolean isPrimitiveType = Utils.isPrimitiveType(extras.get(key));
            try {
                if (isPrimitiveType) {
                    jsonObject.put(key.toString(), extras.get(key));
                    continue;
                }
                jsonObject.put(key.toString(), (Object)new JSONObject(JSON.toJSONString((Object)extras.get(key))));
            }
            catch (JSONException e) {
                L.e("Invalid Json");
            }
        }
        String string = jsonObject.toString(LoggerPrinter.INSTANCE.getJSON_INDENT());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject.toString(LoggerPrinter.JSON_INDENT)");
        return string;
    }
}

