/*
 * Decompiled with CFR 0.152.
 */
package com.sabre.oss.conf4j.json.source;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.sabre.oss.conf4j.source.ConfigurationEntry;
import com.sabre.oss.conf4j.source.IterableConfigurationSource;
import com.sabre.oss.conf4j.source.MapIterable;
import com.sabre.oss.conf4j.source.OptionalValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JsonConfigurationSource
implements IterableConfigurationSource {
    public static final String DEFAULT_PROPERTY = "document";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, String> properties;

    public JsonConfigurationSource(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream cannot be null");
        try {
            ObjectReader objectReader = this.objectMapper.readerFor(Object.class);
            Object object = objectReader.readValue(inputStream);
            this.properties = this.createProperties(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to process JSON.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to close inputStream.", e);
            }
        }
    }

    public JsonConfigurationSource(Reader reader) {
        Objects.requireNonNull(reader, "reader cannot be null");
        try {
            ObjectReader objectReader = this.objectMapper.readerFor(Object.class);
            Object object = objectReader.readValue(reader);
            this.properties = this.createProperties(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to process YAML.", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to close inputStream.", e);
            }
        }
    }

    public JsonConfigurationSource(File file) {
        Objects.requireNonNull(file, "file cannot be null");
        try {
            ObjectReader objectReader = this.objectMapper.readerFor(Object.class);
            Object object = objectReader.readValue(file);
            this.properties = this.createProperties(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to process '%s'.", file), e);
        }
    }

    public OptionalValue<String> getValue(String key, Map<String, String> attributes) {
        return this.properties.containsKey(key) ? OptionalValue.present((Object)this.properties.get(key)) : OptionalValue.absent();
    }

    public Iterable<ConfigurationEntry> getAllConfigurationEntries() {
        return new MapIterable(this.properties);
    }

    private Map<String, String> createProperties(Object object) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.buildFlattenedMap(result, this.createMap(object), null);
        return result;
    }

    private Map<String, Object> createMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put(DEFAULT_PROPERTY, object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.createMap(value);
            }
            if ((key = entry.getKey()) instanceof String) {
                result.put(key.toString(), value);
                continue;
            }
            result.put('[' + key.toString() + ']', value);
        }
        return result;
    }

    private void buildFlattenedMap(Map<String, String> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!StringUtils.isEmpty((CharSequence)path)) {
                key = key.charAt(0) == '[' ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, (String)value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + ']', object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }
}

