/*
 * Decompiled with CFR 0.152.
 */
package com.sabre.oss.conf4j.json.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sabre.oss.conf4j.converter.TypeConverter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class JsonConverter<T>
implements TypeConverter<T> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final boolean ignoreConverterAttribute;

    public JsonConverter() {
        this(false);
    }

    public JsonConverter(boolean ignoreConverterAttribute) {
        this.ignoreConverterAttribute = ignoreConverterAttribute;
    }

    public boolean isApplicable(Type type, Map<String, String> attributes) {
        Objects.requireNonNull(type, "type cannot be null");
        String converter = attributes == null ? null : attributes.get("converter");
        return this.ignoreConverterAttribute || Objects.equals(converter, "json");
    }

    public T fromString(Type type, String value, Map<String, String> attributes) {
        Objects.requireNonNull(type, "type cannot be null");
        if (value == null) {
            return null;
        }
        try {
            ObjectReader objectReader = this.objectMapper.readerFor((Class)type);
            return (T)objectReader.readValue(value);
        }
        catch (IOException e) {
            throw new AssertionError("An IOException occurred when this was assumed to be impossible.", e);
        }
    }

    public String toString(Type type, T value, Map<String, String> attributes) {
        Objects.requireNonNull(type, "type cannot be null");
        if (value == null) {
            return null;
        }
        try {
            ObjectWriter objectWriter = this.objectMapper.writer();
            return objectWriter.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Unable to process JSON.", (IOException)((Object)e));
        }
    }
}

