/*
 * Decompiled with CFR 0.152.
 */
package com.saber.stickyheader.stickyView;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class StickHeaderItemDecoration
extends RecyclerView.ItemDecoration {
    private StickyHeaderInterface mListener;
    private int mStickyHeaderHeight;

    public StickHeaderItemDecoration(@NonNull StickyHeaderInterface listener) {
        this.mListener = listener;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        View topChild = parent.getChildAt(0);
        if (topChild == null) {
            return;
        }
        int topChildPosition = parent.getChildAdapterPosition(topChild);
        if (topChildPosition == -1) {
            return;
        }
        int headerPos = this.mListener.getHeaderPositionForItem(topChildPosition);
        View currentHeader = this.getHeaderViewForItem(headerPos, parent);
        this.fixLayoutSize((ViewGroup)parent, currentHeader);
        int contactPoint = currentHeader.getBottom();
        View childInContact = this.getChildInContact(parent, contactPoint, headerPos);
        if (childInContact != null && this.mListener.isHeader(parent.getChildAdapterPosition(childInContact))) {
            this.moveHeader(c, currentHeader, childInContact);
            return;
        }
        this.drawHeader(c, currentHeader);
    }

    private View getHeaderViewForItem(int headerPosition, RecyclerView parent) {
        int layoutResId = this.mListener.getHeaderLayout(headerPosition);
        View header = LayoutInflater.from((Context)parent.getContext()).inflate(layoutResId, (ViewGroup)parent, false);
        this.mListener.bindHeaderData(header, headerPosition);
        return header;
    }

    private void drawHeader(Canvas c, View header) {
        c.save();
        c.translate(0.0f, 0.0f);
        header.draw(c);
        c.restore();
    }

    private void moveHeader(Canvas c, View currentHeader, View nextHeader) {
        c.save();
        c.translate(0.0f, (float)(nextHeader.getTop() - currentHeader.getHeight()));
        currentHeader.draw(c);
        c.restore();
    }

    private View getChildInContact(RecyclerView parent, int contactPoint, int currentHeaderPos) {
        View childInContact = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            int childBottomPosition;
            boolean isChildHeader;
            int heightTolerance = 0;
            View child = parent.getChildAt(i);
            if (currentHeaderPos != i && (isChildHeader = this.mListener.isHeader(parent.getChildAdapterPosition(child)))) {
                heightTolerance = this.mStickyHeaderHeight - child.getHeight();
            }
            if ((childBottomPosition = child.getTop() > 0 ? child.getBottom() + heightTolerance : child.getBottom()) <= contactPoint || child.getTop() > contactPoint) continue;
            childInContact = child;
            break;
        }
        return childInContact;
    }

    private void fixLayoutSize(ViewGroup parent, View view) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)view.getLayoutParams().width);
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)view.getLayoutParams().height);
        view.measure(childWidthSpec, childHeightSpec);
        this.mStickyHeaderHeight = view.getMeasuredHeight();
        view.layout(0, 0, view.getMeasuredWidth(), this.mStickyHeaderHeight);
    }

    public static interface StickyHeaderInterface {
        public int getHeaderPositionForItem(int var1);

        public int getHeaderLayout(int var1);

        public void bindHeaderData(View var1, int var2);

        public boolean isHeader(int var1);
    }
}

