/*
 * Decompiled with CFR 0.152.
 */
package com.sa90.onepreference;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import com.sa90.onepreference.helper.PhonePreferenceHelper;
import com.sa90.onepreference.helper.PreferenceHelper;
import com.sa90.onepreference.helper.TabletPreferenceHelper;
import com.sa90.onepreference.interfaces.PhonePreference;
import com.sa90.onepreference.interfaces.TabletPreference;
import com.sa90.onepreference.model.Header;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseOnePreferenceActivity
extends AppCompatActivity
implements PhonePreference,
TabletPreference,
AdapterView.OnItemClickListener {
    PhonePreferenceHelper mPhonePreferenceHelper;
    TabletPreferenceHelper mTabletPreferenceHelper;
    ArrayAdapter<Header> mHeaderAdapter;

    public boolean isInTabletMode() {
        return this.getFragmentContainerForPhone() == null;
    }

    public void touchUpHeadersBeforeDisplay(List<Header> targets) {
    }

    public void invalidateHeaders() {
        this.init();
    }

    public void headerClicked(Header clickedHeader, int position) {
        this.mTabletPreferenceHelper.switchFragment(clickedHeader);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.init();
    }

    private void init() {
        LinearLayout llContainer = this.getFragmentContainerForPhone();
        FrameLayout flContainer = this.getFragmentContainerForTablet();
        if (llContainer != null) {
            this.setupForPhone();
        } else if (flContainer != null) {
            this.setupForTablet();
        }
    }

    private void setupForPhone() {
        if (this.mPhonePreferenceHelper == null) {
            this.mPhonePreferenceHelper = new PhonePreferenceHelper(this, this);
        }
        this.mPhonePreferenceHelper.setupScreen(this.getHeadersList());
    }

    private void setupForTablet() {
        ListView lv = this.getHeaderListView();
        if (this.mTabletPreferenceHelper == null) {
            this.mTabletPreferenceHelper = new TabletPreferenceHelper(this, this);
            this.mHeaderAdapter = this.getHeaderListAdapter(this.getHeadersList());
            lv.setChoiceMode(1);
            lv.setAdapter(this.mHeaderAdapter);
            lv.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        } else {
            this.mHeaderAdapter.clear();
            this.mHeaderAdapter.addAll(this.getHeadersList());
            this.mHeaderAdapter.notifyDataSetChanged();
        }
        Header clickedHeader = (Header)this.mHeaderAdapter.getItem(0);
        this.headerClicked(clickedHeader, 0);
        lv.setItemChecked(0, true);
    }

    private List<Header> getHeadersList() {
        ArrayList<Header> headerList = new ArrayList<Header>();
        PreferenceHelper.loadHeadersFromResource(this.getHeaderFile(), headerList, (Activity)this);
        this.touchUpHeadersBeforeDisplay(headerList);
        return headerList;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Header clickedHeader = (Header)this.mHeaderAdapter.getItem(position);
        this.headerClicked(clickedHeader, position);
    }
}

