/*
 * Decompiled with CFR 0.152.
 */
package com.sa90.onepreference.helper;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.support.annotation.XmlRes;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import com.sa90.onepreference.R;
import com.sa90.onepreference.helper.XmlUtils;
import com.sa90.onepreference.model.Header;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class PreferenceHelper {
    private static final long HEADER_ID_UNDEFINED = -1L;

    public static void loadHeadersFromResource(@XmlRes int resid, List<Header> target, Activity mActivity) {
        try (XmlResourceParser parser = null;){
            int type;
            parser = mActivity.getResources().getXml(resid);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"preference-headers".equals(nodeName)) {
                throw new RuntimeException("XML document must start with <preference-headers> tag; found" + nodeName + " at " + parser.getPositionDescription());
            }
            Bundle curBundle = null;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                nodeName = parser.getName();
                if ("header".equals(nodeName)) {
                    Header header = new Header();
                    TypedArray sa = mActivity.obtainStyledAttributes(attrs, R.styleable.PreferenceHeader);
                    header.id = sa.getResourceId(R.styleable.PreferenceHeader_id, -1);
                    TypedValue tv = sa.peekValue(R.styleable.PreferenceHeader_title);
                    if (tv != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.titleRes = tv.resourceId;
                        } else {
                            header.title = tv.string;
                        }
                    }
                    if ((tv = sa.peekValue(R.styleable.PreferenceHeader_summary)) != null && tv.type == 3) {
                        if (tv.resourceId != 0) {
                            header.summaryRes = tv.resourceId;
                        } else {
                            header.summary = tv.string;
                        }
                    }
                    header.iconRes = sa.getResourceId(R.styleable.PreferenceHeader_icon, 0);
                    header.fragment = sa.getString(R.styleable.PreferenceHeader_fragment);
                    sa.recycle();
                    if (curBundle == null) {
                        curBundle = new Bundle();
                    }
                    int innerDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                        if (type == 3 || type == 4) continue;
                        String innerNodeName = parser.getName();
                        if (innerNodeName.equals("extra")) {
                            mActivity.getResources().parseBundleExtra("extra", attrs, curBundle);
                            XmlUtils.skipCurrentTag((XmlPullParser)parser);
                            continue;
                        }
                        if (innerNodeName.equals("intent")) {
                            header.intent = Intent.parseIntent((Resources)mActivity.getResources(), (XmlPullParser)parser, (AttributeSet)attrs);
                            continue;
                        }
                        XmlUtils.skipCurrentTag((XmlPullParser)parser);
                    }
                    if (curBundle.size() > 0) {
                        header.fragmentArguments = curBundle;
                        curBundle = null;
                    }
                    target.add(header);
                    continue;
                }
                XmlUtils.skipCurrentTag((XmlPullParser)parser);
            }
        }
    }
}

