/*
 * Decompiled with CFR 0.152.
 */
package com.sa90.onepreference.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.sa90.onepreference.R;
import com.sa90.onepreference.model.Header;
import java.util.List;

public class HeaderAdapter
extends ArrayAdapter<Header> {
    public HeaderAdapter(Context context, List<Header> objects) {
        super(context, -1, objects);
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.preference_header_item, parent, false);
            HeaderViewHolder headerViewHolder = new HeaderViewHolder(convertView);
            convertView.setTag((Object)headerViewHolder);
        }
        HeaderViewHolder holder = (HeaderViewHolder)convertView.getTag();
        Header header = (Header)this.getItem(position);
        if (header.iconRes == 0) {
            holder.icon.setVisibility(8);
        } else {
            holder.icon.setVisibility(0);
            holder.icon.setImageResource(header.iconRes);
        }
        holder.title.setText(header.getTitle(holder.title.getContext().getResources()));
        CharSequence summary = header.getSummary(holder.title.getContext().getResources());
        if (!TextUtils.isEmpty((CharSequence)summary)) {
            holder.summary.setVisibility(0);
            holder.summary.setText(summary);
        } else {
            holder.summary.setVisibility(8);
        }
        return convertView;
    }

    private static class HeaderViewHolder {
        TextView summary;
        TextView title;
        ImageView icon;

        HeaderViewHolder(View itemView) {
            this.title = (TextView)itemView.findViewById(R.id.tvTitle);
            this.summary = (TextView)itemView.findViewById(R.id.tvSummary);
            this.icon = (ImageView)itemView.findViewById(R.id.icon);
        }
    }
}

