/*
 * Decompiled with CFR 0.152.
 */
package com.sa90.infiniterecyclerview;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;

public abstract class InfiniteAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter {
    private static final int VIEW_TYPE_LOADING = 0;
    private boolean shouldLoadMore = true;
    private boolean isReversedScrolling = false;

    public final RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return this.getLoadingViewHolder(parent);
        }
        return this.onCreateView(parent, viewType);
    }

    public final int getItemCount() {
        int actualCount = this.getCount();
        if (actualCount == 0 || !this.shouldLoadMore || this.isReversedScrolling) {
            return actualCount;
        }
        return actualCount + 1;
    }

    public final int getItemViewType(int position) {
        if (this.isLoadingView(position)) {
            return 0;
        }
        int viewType = this.getViewType(position);
        if (viewType == 0) {
            throw new IndexOutOfBoundsException("0 index is reserved for the loading view");
        }
        return viewType;
    }

    private boolean isLoadingView(int position) {
        int loadingViewPosition = this.isReversedScrolling ? 0 : this.getCount();
        return position == loadingViewPosition && this.shouldLoadMore;
    }

    public void setShouldLoadMore(boolean shouldLoadMore) {
        this.shouldLoadMore = shouldLoadMore;
    }

    public void setIsReversedScrolling(boolean reversed) {
        this.isReversedScrolling = reversed;
    }

    public abstract RecyclerView.ViewHolder getLoadingViewHolder(ViewGroup var1);

    public abstract int getCount();

    public abstract int getViewType(int var1);

    public abstract VH onCreateView(ViewGroup var1, int var2);
}

