/*
 * Decompiled with CFR 0.152.
 */
package com.sa90.infiniterecyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.sa90.infiniterecyclerview.InfiniteAdapter;
import com.sa90.infiniterecyclerview.R;
import com.sa90.infiniterecyclerview.listener.OnLoadMoreListener;

public class InfiniteRecyclerView
extends RecyclerView {
    private static final int VISIBLE_THRESHOLD = 5;
    private boolean loading;
    private boolean shouldLoadMore;
    private OnLoadMoreListener onLoadMoreListener;
    private LinearLayoutManager mLayoutManager;
    private InfiniteAdapter mAdapter;
    private int mVisibleThreshold;
    private RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            int visibleItemCount = InfiniteRecyclerView.this.getChildCount();
            int totalItemCount = InfiniteRecyclerView.this.mAdapter.getItemCount();
            int firstVisibleItem = InfiniteRecyclerView.this.mLayoutManager.findFirstVisibleItemPosition();
            if (InfiniteRecyclerView.this.shouldLoadMore && !InfiniteRecyclerView.this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + InfiniteRecyclerView.this.mVisibleThreshold) {
                InfiniteRecyclerView.this.loading = true;
                if (InfiniteRecyclerView.this.onLoadMoreListener != null) {
                    InfiniteRecyclerView.this.onLoadMoreListener.onLoadMore();
                }
            }
        }
    };

    public InfiniteRecyclerView(Context context) {
        super(context);
        this.init(null);
    }

    public InfiniteRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.InfiniteRecyclerView, 0, 0);
        this.init(attr);
    }

    public InfiniteRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.InfiniteRecyclerView, 0, 0);
        this.init(attr);
    }

    private void init(TypedArray attr) {
        this.addOnScrollListener(this.mScrollListener);
        this.loading = false;
        this.shouldLoadMore = true;
        this.mVisibleThreshold = attr != null ? attr.getInt(R.styleable.InfiniteRecyclerView_irv_visible_threshold, 5) : 5;
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
        if (!(adapter instanceof InfiniteAdapter)) {
            throw new UnsupportedOperationException("This RecyclerView's adapter should extend from InfiniteScrollAdapter");
        }
        this.mAdapter = (InfiniteAdapter)adapter;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout) {
        super.setLayoutManager(layout);
        if (!(layout instanceof LinearLayoutManager)) {
            throw new UnsupportedOperationException("This recycler view can only be used with LinearLayoutManager");
        }
        this.mLayoutManager = (LinearLayoutManager)layout;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    public void moreDataLoaded() {
        this.loading = false;
        this.mAdapter.notifyDataSetChanged();
    }

    public void moreDataLoaded(int positionStart, int itemCount) {
        this.loading = false;
        this.mAdapter.notifyItemRangeInserted(positionStart, itemCount);
    }

    public void setShouldLoadMore(boolean loadMore) {
        this.shouldLoadMore = loadMore;
        this.mAdapter.setShouldLoadMore(this.shouldLoadMore);
    }
}

