/*
 * Decompiled with CFR 0.152.
 */
package com.s24.search.solr.util.analyzing;

import com.google.common.base.Preconditions;

public class Position {
    private final Integer start;
    private final Integer end;
    private final Integer wordPosition;

    public Position(Integer start, Integer end, Integer wordPosition) {
        this.start = start;
        this.end = end;
        this.wordPosition = wordPosition;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public Integer getWordPosition() {
        return this.wordPosition;
    }

    public boolean matches(Position other) {
        Preconditions.checkNotNull((Object)other, (Object)"Pre-condition violated: other must not be null.");
        return this.getStart().equals(other.getStart()) && this.getEnd().equals(other.getEnd());
    }

    public boolean contains(Position other) {
        Preconditions.checkNotNull((Object)other, (Object)"Pre-condition violated: other must not be null.");
        return this.getStart() <= other.getStart() && this.getEnd() >= other.getEnd();
    }

    public int hashCode() {
        return (this.start != null ? this.start.hashCode() : 0) + (this.end != null ? this.end.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Position) {
            Position other = (Position)obj;
            return other.getStart().equals(this.getStart()) && other.getEnd().equals(this.getEnd());
        }
        return false;
    }

    public String toString() {
        return String.format("start: %d end: %d", this.start, this.end);
    }
}

