/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.reporter.AbstractReporterFactoryBean;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public class JmxReporterFactoryBean
extends AbstractReporterFactoryBean<JmxReporter>
implements SmartLifecycle,
DisposableBean {
    public static final String DOMAIN = "domain";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";
    public static final String MBEAN_SERVER_REF = "mbean-server-ref";
    private boolean running = false;

    @Override
    public Class<JmxReporter> getObjectType() {
        return JmxReporter.class;
    }

    @Override
    protected JmxReporter createInstance() {
        JmxReporter.Builder reporter = JmxReporter.forRegistry((MetricRegistry)this.getMetricRegistry());
        if (this.hasProperty(DOMAIN)) {
            reporter.inDomain(this.getProperty(DOMAIN));
        }
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.convertDurationsTo(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.convertRatesTo(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        reporter.filter(this.getMetricFilter());
        if (this.hasProperty(MBEAN_SERVER_REF)) {
            reporter.registerWith(this.getPropertyRef(MBEAN_SERVER_REF, MBeanServer.class));
        }
        return reporter.build();
    }

    public void start() {
        if (!this.running) {
            ((JmxReporter)this.getObject()).start();
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            ((JmxReporter)this.getObject()).stop();
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    public int getPhase() {
        return 0;
    }
}

