/*
 * Decompiled with CFR 0.152.
 */
package com.ryane.banner.loader;

import android.content.Context;
import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.SimpleDraweeView;
import com.ryane.banner.AdPageInfo;
import com.ryane.banner.AdPlayBanner;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;

public class ImageLoaderManager {
    private AdPlayBanner.ImageLoaderType mImageLoaderType = AdPlayBanner.ImageLoaderType.FRESCO;
    private AdPlayBanner.OnPageClickListener mOnPageClickListener = null;
    private AdPlayBanner.ScaleType mScaleType = AdPlayBanner.ScaleType.FIT_XY;
    private final ArrayList<Object> mViewCaches = new ArrayList();

    private ImageLoaderManager() {
    }

    public static ImageLoaderManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void setImageLoaderType(AdPlayBanner.ImageLoaderType type) {
        this.mImageLoaderType = type;
    }

    public void setScaleType(AdPlayBanner.ScaleType mScaleType) {
        this.mScaleType = mScaleType;
    }

    public Object initPageView(ViewGroup container, Context context, final AdPageInfo info, final int position) {
        ImageView mPicassoView;
        if (container == null || context == null || info == null || position < 0) {
            return null;
        }
        Uri uri = Uri.parse((String)info.getPicUrl());
        switch (this.mImageLoaderType) {
            default: {
                SimpleDraweeView mFrescoView;
                if (this.mViewCaches.isEmpty()) {
                    mFrescoView = new SimpleDraweeView(context);
                    mFrescoView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                    this.frescoViewSetScaleType(context, mFrescoView);
                } else {
                    mFrescoView = (SimpleDraweeView)this.mViewCaches.remove(0);
                }
                mFrescoView.setImageURI(uri);
                container.addView((View)mFrescoView);
                mFrescoView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ImageLoaderManager.this.mOnPageClickListener != null) {
                            ImageLoaderManager.this.mOnPageClickListener.onPageClick(info, position);
                        }
                    }
                });
                return mFrescoView;
            }
            case GLIDE: {
                ImageView mGlideView;
                if (this.mViewCaches.isEmpty()) {
                    mGlideView = new ImageView(context);
                    mGlideView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                    this.imageViewSetScaleType(mGlideView);
                } else {
                    mGlideView = (ImageView)this.mViewCaches.remove(0);
                }
                Glide.with((FragmentActivity)((AppCompatActivity)context)).load((Object)info.getPicUrl()).into(mGlideView);
                container.addView((View)mGlideView);
                mGlideView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ImageLoaderManager.this.mOnPageClickListener != null) {
                            ImageLoaderManager.this.mOnPageClickListener.onPageClick(info, position);
                        }
                    }
                });
                return mGlideView;
            }
            case PICASSO: 
        }
        if (this.mViewCaches.isEmpty()) {
            mPicassoView = new ImageView(context);
            mPicassoView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.imageViewSetScaleType(mPicassoView);
        } else {
            mPicassoView = (ImageView)this.mViewCaches.remove(0);
        }
        Picasso.with((Context)context).load(info.getPicUrl()).into(mPicassoView);
        mPicassoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageLoaderManager.this.mOnPageClickListener != null) {
                    ImageLoaderManager.this.mOnPageClickListener.onPageClick(info, position);
                }
            }
        });
        container.addView((View)mPicassoView);
        return mPicassoView;
    }

    public void destroyPageView(ViewGroup container, Object object) {
        switch (this.mImageLoaderType) {
            default: {
                SimpleDraweeView mFrescoView = (SimpleDraweeView)object;
                container.removeView((View)mFrescoView);
                this.mViewCaches.add(mFrescoView);
                break;
            }
            case GLIDE: {
                ImageView mGlideView = (ImageView)object;
                container.removeView((View)mGlideView);
                this.mViewCaches.add(mGlideView);
                break;
            }
            case PICASSO: {
                ImageView mPicassoView = (ImageView)object;
                container.removeView((View)mPicassoView);
                this.mViewCaches.add(mPicassoView);
            }
        }
    }

    public void setOnPageClickListener(AdPlayBanner.OnPageClickListener listener) {
        this.mOnPageClickListener = listener;
    }

    private void frescoViewSetScaleType(Context context, SimpleDraweeView mFrescoView) {
        if (context == null || mFrescoView == null) {
            return;
        }
        GenericDraweeHierarchyBuilder builder = new GenericDraweeHierarchyBuilder(context.getResources());
        GenericDraweeHierarchy hierarchy = builder.build();
        mFrescoView.setHierarchy((DraweeHierarchy)hierarchy);
        switch (this.mScaleType) {
            default: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.FIT_XY);
                break;
            }
            case FIT_START: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.FIT_START);
                break;
            }
            case FIT_CENTER: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER);
                break;
            }
            case FIT_END: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.FIT_END);
                break;
            }
            case CENTER: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.CENTER);
                break;
            }
            case CENTER_CROP: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.CENTER_CROP);
                break;
            }
            case CENTER_INSIDE: {
                hierarchy.setActualImageScaleType(ScalingUtils.ScaleType.CENTER_INSIDE);
            }
        }
    }

    private void imageViewSetScaleType(ImageView imageView) {
        if (imageView == null) {
            return;
        }
        switch (this.mScaleType) {
            default: {
                imageView.setScaleType(ImageView.ScaleType.FIT_XY);
                break;
            }
            case FIT_START: {
                imageView.setScaleType(ImageView.ScaleType.FIT_START);
                break;
            }
            case FIT_CENTER: {
                imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                break;
            }
            case FIT_END: {
                imageView.setScaleType(ImageView.ScaleType.FIT_END);
                break;
            }
            case CENTER: {
                imageView.setScaleType(ImageView.ScaleType.CENTER);
                break;
            }
            case CENTER_CROP: {
                imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                break;
            }
            case CENTER_INSIDE: {
                imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            }
        }
    }

    private static class SingletonHolder {
        private static final ImageLoaderManager INSTANCE = new ImageLoaderManager();

        private SingletonHolder() {
        }
    }
}

