/*
 * Decompiled with CFR 0.152.
 */
package com.ryane.banner.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ryane.banner.R;

public class TitleView
extends RelativeLayout {
    private TextView mTitle;
    private RelativeLayout mContainer;
    public Gravity gravity = Gravity.PARENT_BOTTOM;
    public int marginTop = 0;
    public int marginBottom = 0;
    public int marginLeft = 0;
    public int marginRight = 0;

    public TitleView(Context context) {
        this(context, null);
    }

    public TitleView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_title, (ViewGroup)this, true);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mContainer = (RelativeLayout)this.findViewById(R.id.titleContainer);
    }

    public static TitleView getDefaultTitleView(Context context) {
        TitleView titleView = new TitleView(context);
        titleView.setPosition(Gravity.PARENT_BOTTOM).setTitleMargin(0, 0, 0, 20).setTitlePadding(2, 5, 2, 5).setViewBackground(ContextCompat.getColor((Context)context, (int)R.color.grey)).setTitleColor(ContextCompat.getColor((Context)context, (int)R.color.white)).setTitleSize(15);
        return titleView;
    }

    public void setTitle(String title) {
        if (this.mTitle != null && !TextUtils.isEmpty((CharSequence)title)) {
            this.mTitle.setText((CharSequence)title);
        }
    }

    public TitleView setTitleSize(int size) {
        if (this.mTitle != null) {
            this.mTitle.setTextSize((float)size);
        }
        return this;
    }

    public TitleView setTitleColor(int color2) {
        if (this.mTitle != null) {
            this.mTitle.setTextColor(color2);
        }
        return this;
    }

    public TitleView setViewBackground(int color2) {
        this.mContainer.setBackgroundColor(color2);
        return this;
    }

    public TitleView setPosition(Gravity gravity) {
        this.gravity = gravity;
        return this;
    }

    public TitleView setTitleMargin(int left, int top, int right, int bottom) {
        this.marginTop = top;
        this.marginBottom = bottom;
        this.marginLeft = left;
        this.marginRight = right;
        return this;
    }

    public TitleView setTitlePadding(int left, int top, int right, int bottom) {
        if (this.mTitle != null) {
            this.mTitle.setPadding(this.change2Dp(left), this.change2Dp(top), this.change2Dp(right), this.change2Dp(bottom));
        }
        return this;
    }

    private int change2Dp(int value) {
        return (int)TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public static enum Gravity {
        PARENT_TOP(0),
        PARENT_BOTTOM(1),
        PARENT_CENTER(2);

        final int nativeInt;

        private Gravity(int ni) {
            this.nativeInt = ni;
        }
    }
}

