/*
 * Decompiled with CFR 0.152.
 */
package com.ryane.banner.view;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class PointView
extends AppCompatTextView {
    private float mSize;
    private int mColor = -769226;

    public PointView(Context context) {
        this(context, null);
    }

    public PointView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PointView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public PointView(Context context, float mSize, int mColor) {
        super(context);
        this.mSize = mSize;
        this.mColor = mColor;
        this.setDefault(mSize);
    }

    private void setDefault(float size) {
        this.setGravity(17);
        this.setTextColor(-1);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mSize = size <= 0.0f ? TypedValue.applyDimension((int)1, (float)14.0f, (DisplayMetrics)metrics) : size;
        if ((double)metrics.density <= 1.5) {
            this.setTextSize(1, 9.0f);
        } else {
            this.setTextSize(2, 10.0f);
        }
        int paddingLeft = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)metrics);
        int paddingRight = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)metrics);
        this.setPadding(paddingLeft, 0, paddingRight, 0);
        this.change();
    }

    private void change() {
        float[] outerR = new float[]{this.mSize / 2.0f, this.mSize / 2.0f, this.mSize / 2.0f, this.mSize / 2.0f, this.mSize / 2.0f, this.mSize / 2.0f, this.mSize / 2.0f, this.mSize / 2.0f};
        RoundRectShape shape = new RoundRectShape(outerR, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)shape);
        shapeDrawable.setIntrinsicHeight((int)this.mSize);
        shapeDrawable.setIntrinsicWidth((int)this.mSize);
        shapeDrawable.setPadding(0, 0, 0, 0);
        shapeDrawable.getPaint().setColor(this.mColor);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        this.setBackgroundDrawable((Drawable)shapeDrawable);
        this.setHeight((int)this.mSize);
        this.setMinWidth((int)this.mSize);
    }

    public void setPointViewColor(int mColor) {
        this.mColor = mColor;
        this.change();
    }
}

