/*
 * Decompiled with CFR 0.152.
 */
package com.ryane.banner;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.ryane.banner.AdPageInfo;
import com.ryane.banner.AdPlayBanner;
import com.ryane.banner.R;
import com.ryane.banner.ScrollerPagerAdapter;
import com.ryane.banner.indicator.IndicatorManager;
import com.ryane.banner.scroller.AutoPlayScroller;
import com.ryane.banner.util.ListUtils;
import com.ryane.banner.util.OsUtil;
import com.ryane.banner.view.NumberView;
import com.ryane.banner.view.PointView;
import com.ryane.banner.view.TitleView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ScrollerPager
extends ViewPager {
    private RelativeLayout mContainer;
    private TitleView mTitleView;
    private LinearLayout mIndicator;
    private LinearLayout mPageNumberLayout;
    private List<AdPageInfo> mDataList;
    private Handler mUIHandler = new Handler(Looper.myLooper());
    private PointView[] mPointViews = null;
    private NumberView[] mNumberViews = null;
    private final int POINT_VIEW_SELECTED_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.point_selected_color);
    private final int POINT_VIEW_NORMAL_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.point_normal_color);
    public static ViewPager.PageTransformer mTransformer = null;
    public static boolean mAutoPlay = true;
    public static boolean canScroll = true;
    public static int mInterval = 2000;
    private int mSelectedIndex = 0;
    private AdPlayBanner.OnPagerChangeListener mPageListener;
    private ViewPager.OnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            int i;
            if (ScrollerPager.this.mPageListener != null) {
                int pos = ScrollerPager.this.mDataList == null || ScrollerPager.this.mDataList.size() == 0 ? 0 : position % ScrollerPager.this.mDataList.size();
                ScrollerPager.this.mPageListener.onPageSelected(pos);
            }
            if (ListUtils.isEmpty(ScrollerPager.this.mDataList)) {
                return;
            }
            ScrollerPager.this.mSelectedIndex = position;
            int rightPos = position % ScrollerPager.this.mDataList.size();
            if (ScrollerPager.this.mTitleView != null) {
                ScrollerPager.this.mTitleView.setTitle(((AdPageInfo)ScrollerPager.this.mDataList.get(rightPos)).getTitle());
            }
            if (IndicatorManager.getInstance().getIndicatorType() == AdPlayBanner.IndicatorType.POINT_INDICATOR && ScrollerPager.this.mPointViews != null && ScrollerPager.this.mPointViews.length > 0) {
                ScrollerPager.this.mPointViews[rightPos].setPointViewColor(ScrollerPager.this.POINT_VIEW_SELECTED_COLOR);
                for (i = 0; i < ScrollerPager.this.mPointViews.length; ++i) {
                    if (rightPos == i) continue;
                    ScrollerPager.this.mPointViews[i].setPointViewColor(ScrollerPager.this.POINT_VIEW_NORMAL_COLOR);
                }
            }
            if (IndicatorManager.getInstance().getIndicatorType() == AdPlayBanner.IndicatorType.NUMBER_INDICATOR && ScrollerPager.this.mPageNumberLayout != null && ScrollerPager.this.mNumberViews.length > 0) {
                ScrollerPager.this.mNumberViews[rightPos].setNumberViewColor(NumberView.mNumberViewSelectedColor);
                for (i = 0; i < ScrollerPager.this.mNumberViews.length; ++i) {
                    if (rightPos == i) continue;
                    ScrollerPager.this.mNumberViews[i].setNumberViewColor(NumberView.mNumberViewNormalColor);
                }
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (ScrollerPager.this.mPageListener != null) {
                int pos = ScrollerPager.this.mDataList == null || ScrollerPager.this.mDataList.size() == 0 ? 0 : position % ScrollerPager.this.mDataList.size();
                ScrollerPager.this.mPageListener.onPageScrolled(pos, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (ScrollerPager.this.mPageListener != null) {
                ScrollerPager.this.mPageListener.onPageScrollStateChanged(state);
            }
            if (state == 0) {
                ScrollerPager.this.startAdvertPlay();
            }
        }
    };
    private Runnable mImageTimmerTask = new Runnable(){

        @Override
        public void run() {
            if (ScrollerPager.this.mSelectedIndex == Integer.MAX_VALUE) {
                if (ListUtils.isEmpty(ScrollerPager.this.mDataList)) {
                    return;
                }
                int rightPos = ScrollerPager.this.mSelectedIndex % ScrollerPager.this.mDataList.size();
                ScrollerPager.this.setCurrentItem(ScrollerPager.this.getInitPosition() + rightPos + 1, true);
            } else {
                ScrollerPager.this.setCurrentItem(ScrollerPager.this.mSelectedIndex + 1, true);
            }
        }
    };

    public ScrollerPager(Context context) {
        this(context, null);
    }

    public ScrollerPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ScrollerPager(RelativeLayout mContainer, TitleView mTitleView, List<AdPageInfo> infos) {
        super(mContainer.getContext());
        this.mContainer = mContainer;
        this.mTitleView = mTitleView;
        this.mDataList = null != infos ? infos : new ArrayList<AdPageInfo>();
        this.init();
    }

    private void init() {
        this.initIndicator();
        this.initPageNumber();
        this.initScrollTime(new AutoPlayScroller(this.getContext(), (Interpolator)new LinearInterpolator()));
        this.initTransformer();
        ScrollerPagerAdapter adapter = new ScrollerPagerAdapter(this.getContext(), this.mDataList);
        this.setAdapter(adapter);
        this.addOnPageChangeListener(this.mOnPageChangeListener);
    }

    private void initIndicator() {
        if (IndicatorManager.getInstance().getIndicatorType() == AdPlayBanner.IndicatorType.POINT_INDICATOR) {
            this.mIndicator = new LinearLayout(this.getContext());
            this.mIndicator.setOrientation(0);
            this.mIndicator.setGravity(17);
            this.mIndicator.removeAllViews();
            this.mPointViews = new PointView[this.mDataList.size()];
            float pointSize = OsUtil.dpToPx(5);
            int size = this.mDataList.size();
            for (int i = 0; i < size; ++i) {
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams((int)pointSize, (int)pointSize);
                layoutParams.leftMargin = (int)(pointSize / 2.0f);
                layoutParams.rightMargin = (int)(pointSize / 2.0f);
                PointView pointView = i == this.mSelectedIndex ? new PointView(this.getContext(), pointSize, ContextCompat.getColor((Context)this.getContext(), (int)R.color.point_selected_color)) : new PointView(this.getContext(), pointSize, ContextCompat.getColor((Context)this.getContext(), (int)R.color.point_normal_color));
                if (i == 0) {
                    layoutParams.leftMargin = 0;
                }
                if (i == size - 1) {
                    layoutParams.rightMargin = 0;
                }
                layoutParams.topMargin = (int)pointSize;
                layoutParams.bottomMargin = (int)pointSize;
                this.mPointViews[i] = pointView;
                this.mIndicator.addView((View)this.mPointViews[i], (ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    private void initPageNumber() {
        if (IndicatorManager.getInstance().getIndicatorType() == AdPlayBanner.IndicatorType.NUMBER_INDICATOR) {
            this.mPageNumberLayout = new LinearLayout(this.getContext());
            this.mPageNumberLayout.setOrientation(0);
            this.mPageNumberLayout.setGravity(17);
            this.mPageNumberLayout.removeAllViews();
            this.mNumberViews = new NumberView[this.mDataList.size()];
            int size = this.mDataList.size();
            for (int i = 0; i < size; ++i) {
                NumberView numberView = i == this.mSelectedIndex ? new NumberView(this.getContext(), NumberView.mNumberViewSelectedColor) : new NumberView(this.getContext(), NumberView.mNumberViewNormalColor);
                numberView.setNumber(i + 1);
                this.mNumberViews[i] = numberView;
                this.mPageNumberLayout.addView((View)this.mNumberViews[i]);
            }
        }
    }

    private void initScrollTime(Scroller mScroller) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            mField.set((Object)this, mScroller);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void startAdvertPlay() {
        if (mAutoPlay) {
            this.stopAdvertPlay();
            this.mUIHandler.postDelayed(this.mImageTimmerTask, (long)mInterval);
        }
    }

    private void stopAdvertPlay() {
        this.mUIHandler.removeCallbacks(this.mImageTimmerTask);
    }

    private int getInitPosition() {
        if (ListUtils.isEmpty(this.mDataList)) {
            return 0;
        }
        int halfValue = 0x3FFFFFFF;
        int position = halfValue % this.mDataList.size();
        return halfValue - position;
    }

    public void setNumberViewColor(int normalColor, int selectedColor, int numberColor) {
        NumberView.mNumberViewNormalColor = normalColor;
        NumberView.mNumberViewSelectedColor = selectedColor;
        NumberView.mNumberTextColor = numberColor;
        this.initPageNumber();
    }

    public void setTitleView(TitleView mTitleView) {
        this.mTitleView = mTitleView;
    }

    private void initTransformer() {
        if (mTransformer == null) {
            return;
        }
        this.setPageTransformer(true, mTransformer);
    }

    public void show() {
        this.mContainer.removeAllViews();
        if (null == this.mDataList || 0 == this.mDataList.size()) {
            this.stopAdvertPlay();
            this.mContainer.setVisibility(8);
        } else {
            this.addScrollerPager();
            this.addIndicatorView();
            this.addPageNumberView();
            this.addTitleView();
            if (this.mDataList.size() == 1) {
                this.stopAdvertPlay();
            } else {
                this.startAdvertPlay();
            }
            this.mContainer.setVisibility(0);
            this.setCurrentItem(this.getInitPosition());
        }
    }

    public void stop() {
        this.stopAdvertPlay();
    }

    private void addScrollerPager() {
        ViewPager.LayoutParams layoutParams = new ViewPager.LayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        this.mContainer.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
    }

    private void addPageNumberView() {
        if (IndicatorManager.getInstance().getIndicatorType() == AdPlayBanner.IndicatorType.NUMBER_INDICATOR && this.mPageNumberLayout != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(12);
            layoutParams.bottomMargin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
            this.mContainer.addView((View)this.mPageNumberLayout, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void addIndicatorView() {
        if (IndicatorManager.getInstance().getIndicatorType() == AdPlayBanner.IndicatorType.POINT_INDICATOR && this.mIndicator != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(12);
            layoutParams.bottomMargin = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
            this.mContainer.addView((View)this.mIndicator, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void addTitleView() {
        if (this.mTitleView != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            switch (this.mTitleView.gravity) {
                default: {
                    layoutParams.addRule(12);
                    break;
                }
                case PARENT_TOP: {
                    layoutParams.addRule(10);
                    break;
                }
                case PARENT_CENTER: {
                    layoutParams.addRule(13);
                }
            }
            layoutParams.topMargin = OsUtil.dpToPx(this.mTitleView.marginTop);
            layoutParams.bottomMargin = OsUtil.dpToPx(this.mTitleView.marginBottom);
            layoutParams.leftMargin = OsUtil.dpToPx(this.mTitleView.marginLeft);
            layoutParams.rightMargin = OsUtil.dpToPx(this.mTitleView.marginRight);
            this.mContainer.addView((View)this.mTitleView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (canScroll) {
            return super.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.performClick();
                this.stopAdvertPlay();
                break;
            }
            case 1: {
                this.startAdvertPlay();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean performClick() {
        return super.performClick();
    }

    public void setmPageListener(AdPlayBanner.OnPagerChangeListener mPageListener) {
        this.mPageListener = mPageListener;
    }
}

