/*
 * Decompiled with CFR 0.152.
 */
package com.ryane.banner;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.ryane.banner.AdPageInfo;
import com.ryane.banner.ScrollerPager;
import com.ryane.banner.indicator.IndicatorManager;
import com.ryane.banner.loader.ImageLoaderManager;
import com.ryane.banner.sort.QuickSort;
import com.ryane.banner.view.NumberView;
import com.ryane.banner.view.TitleView;
import java.util.ArrayList;
import java.util.List;

public class AdPlayBanner
extends RelativeLayout {
    private List<AdPageInfo> mDataList;
    private ScrollerPager mScrollerPager;
    private TitleView mTitleView;
    private OnPagerChangeListener mPageChangeListener = null;

    public AdPlayBanner(Context context) {
        this(context, null);
    }

    public AdPlayBanner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AdPlayBanner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public AdPlayBanner addTitleView(TitleView mTitleView) {
        this.mTitleView = mTitleView;
        if (this.mScrollerPager != null) {
            this.mScrollerPager.setTitleView(mTitleView);
        }
        return this;
    }

    public AdPlayBanner setBannerBackground(int color2) {
        this.setBackgroundColor(color2);
        return this;
    }

    public AdPlayBanner setIndicatorType(IndicatorType type) {
        IndicatorManager.getInstance().setIndicatorType(type);
        return this;
    }

    public AdPlayBanner setInfoList(List<AdPageInfo> dataList) {
        this.mDataList = null != dataList ? QuickSort.quickSort(dataList, 0, dataList.size() - 1) : new ArrayList<AdPageInfo>();
        return this;
    }

    public AdPlayBanner setInterval(int interval) {
        ScrollerPager.mInterval = interval;
        return this;
    }

    public AdPlayBanner setImageLoadType(ImageLoaderType type) {
        ImageLoaderManager.getInstance().setImageLoaderType(type);
        return this;
    }

    public AdPlayBanner setPageTransformer(ViewPager.PageTransformer transformer) {
        if (this.mScrollerPager != null) {
            this.mScrollerPager.setPageTransformer(true, transformer);
        } else {
            ScrollerPager.mTransformer = transformer;
        }
        return this;
    }

    public AdPlayBanner setNumberViewColor(int normalColor, int selectedColor, int numberColor) {
        if (this.mScrollerPager != null) {
            this.mScrollerPager.setNumberViewColor(normalColor, selectedColor, numberColor);
        } else {
            NumberView.mNumberViewNormalColor = normalColor;
            NumberView.mNumberViewSelectedColor = selectedColor;
            NumberView.mNumberTextColor = numberColor;
        }
        return this;
    }

    public AdPlayBanner setOnPageClickListener(OnPageClickListener listener) {
        ImageLoaderManager.getInstance().setOnPageClickListener(listener);
        return this;
    }

    public AdPlayBanner setOnPagerChangeListener(OnPagerChangeListener listener) {
        if (this.mScrollerPager != null) {
            this.mScrollerPager.setmPageListener(listener);
        } else {
            this.mPageChangeListener = listener;
        }
        return this;
    }

    public AdPlayBanner setImageViewScaleType(ScaleType scaleType) {
        ImageLoaderManager.getInstance().setScaleType(scaleType);
        return this;
    }

    public AdPlayBanner setAutoPlay(boolean autoPlay) {
        ScrollerPager.mAutoPlay = autoPlay;
        return this;
    }

    public AdPlayBanner setCanScroll(boolean canScroll) {
        ScrollerPager.canScroll = canScroll;
        return this;
    }

    public void setUp() {
        this.mScrollerPager = new ScrollerPager(this, this.mTitleView, this.mDataList);
        if (this.mPageChangeListener != null) {
            this.mScrollerPager.setmPageListener(this.mPageChangeListener);
        }
        this.mScrollerPager.show();
    }

    public void stop() {
        if (this.mScrollerPager == null) {
            return;
        }
        this.mScrollerPager.stop();
        this.removeAllViews();
    }

    public static enum IndicatorType {
        NONE_INDICATOR(0),
        NUMBER_INDICATOR(1),
        POINT_INDICATOR(2);

        final int nativeInt;

        private IndicatorType(int ni) {
            this.nativeInt = ni;
        }
    }

    public static enum ImageLoaderType {
        FRESCO(1),
        GLIDE(2),
        PICASSO(3);

        final int nativeInt;

        private ImageLoaderType(int ni) {
            this.nativeInt = ni;
        }
    }

    public static enum ScaleType {
        FIT_XY(1),
        FIT_START(2),
        FIT_CENTER(3),
        FIT_END(4),
        CENTER(5),
        CENTER_CROP(6),
        CENTER_INSIDE(7);

        final int nativeInt;

        private ScaleType(int ni) {
            this.nativeInt = ni;
        }
    }

    public static interface OnPagerChangeListener {
        public void onPageSelected(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageScrollStateChanged(int var1);
    }

    public static interface OnPageClickListener {
        public void onPageClick(AdPageInfo var1, int var2);
    }
}

