/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.region;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rws.lt.lc.publicapi.sdk.exception.ApiErrorException;
import com.rws.lt.lc.publicapi.sdk.exception.ApiErrorResponse;
import com.rws.lt.lc.publicapi.sdk.region.RegionConstants;
import com.rws.lt.lc.publicapi.sdk.region.RegionsResponseModel;
import feign.Request;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionDiscoverer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionDiscoverer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public String getRegionHostForRegionCode(String requestedRegion) {
        try {
            HttpRequest request = HttpRequest.newBuilder().header("Content-Type", "application/json").uri(URI.create(RegionConstants.GLOBAL_REGIONS_URL)).GET().build();
            LOGGER.debug("Requesting regions from {} to retrieve region {}", (Object)RegionConstants.GLOBAL_REGIONS_URL, (Object)requestedRegion);
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            RegionsResponseModel regionsResponse = (RegionsResponseModel)this.objectMapper.readValue(response.body(), RegionsResponseModel.class);
            LOGGER.debug("Regions response: {}", (Object)regionsResponse);
            return this.extractApiHostForCode(regionsResponse, requestedRegion);
        }
        catch (IOException | InterruptedException e) {
            throw new ApiErrorException(new ApiErrorResponse(), 500, RegionConstants.GLOBAL_REGIONS_URL, Request.HttpMethod.POST, e.getMessage());
        }
    }

    private String extractApiHostForCode(RegionsResponseModel regionsResponse, String requestedRegion) {
        return regionsResponse.getItems().stream().filter(region -> requestedRegion.equalsIgnoreCase(region.getRegionCode())).findFirst().map(region -> region.getHosts().getApiHost()).orElseThrow(() -> new ApiErrorException(new ApiErrorResponse(), 404, RegionConstants.GLOBAL_REGIONS_URL, Request.HttpMethod.GET, String.format("Region %s not found in available regions", requestedRegion)));
    }
}

