/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.multipart;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.codec.EncodeException;
import feign.form.multipart.AbstractWriter;
import feign.form.multipart.Output;
import lombok.NonNull;

public class CustomPojoWriter
extends AbstractWriter {
    private final ObjectMapper objectMapper;

    public CustomPojoWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isApplicable(Object object) {
        return this.isUserPojo(object);
    }

    public void write(Output output, String boundary, String key, Object object) throws EncodeException {
        String data = "";
        try {
            data = this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        String string = "--" + boundary + "\r\n" + "Content-Disposition: form-data; name=\"" + key + '\"' + "\r\n" + "Content-Type: application/json; charset=" + output.getCharset().name() + "\r\n" + "\r\n" + data + "\r\n";
        output.write(string);
    }

    private boolean isUserPojo(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Class<?> type = object.getClass();
        Package typePackage = type.getPackage();
        return typePackage != null && typePackage.getName().startsWith("com.rws.");
    }
}

