/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.multipart;

import com.rws.lt.lc.publicapi.sdk.multipart.FileResponse;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;

public class CustomDecoder
implements Decoder {
    private final JacksonDecoder jacksonDecoder;

    public CustomDecoder(JacksonDecoder jacksonDecoder) {
        this.jacksonDecoder = jacksonDecoder;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (!type.equals(FileResponse.class)) {
            return this.jacksonDecoder.decode(response, type);
        }
        if (response.status() == 404) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        return this.createFileResponse(response);
    }

    private FileResponse createFileResponse(Response response) throws IOException {
        byte[] inputStream = response.body().asInputStream().readAllBytes();
        return new FileResponse(response.status(), response.headers(), inputStream);
    }
}

