/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rws.lt.lc.publicapi.sdk.model.ObjectId;
import com.rws.lt.lc.publicapi.sdk.model.TaskEventAssignees;
import com.rws.lt.lc.publicapi.sdk.model.TaskEventTaskType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "status", "outcome", "taskType", "project", "owner", "location", "assignees", "dueBy"})
@JsonTypeName(value="task-event")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskEvent {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private JsonNullable<OutcomeEnum> outcome = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TASK_TYPE = "taskType";
    @Nonnull
    private TaskEventTaskType taskType;
    public static final String JSON_PROPERTY_PROJECT = "project";
    @Nullable
    private ObjectId project;
    public static final String JSON_PROPERTY_OWNER = "owner";
    @Nullable
    private ObjectId owner;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nullable
    private ObjectId location;
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    @Nonnull
    private List<TaskEventAssignees> assignees;
    public static final String JSON_PROPERTY_DUE_BY = "dueBy";
    @Nullable
    private DateTime dueBy;

    public TaskEvent() {
    }

    @JsonCreator
    public TaskEvent(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="status", required=true) StatusEnum status, @JsonProperty(value="outcome") JsonNullable<OutcomeEnum> outcome, @JsonProperty(value="taskType", required=true) TaskEventTaskType taskType, @JsonProperty(value="project") ObjectId project, @JsonProperty(value="owner") ObjectId owner, @JsonProperty(value="location") ObjectId location, @JsonProperty(value="assignees", required=true) List<TaskEventAssignees> assignees, @JsonProperty(value="dueBy") DateTime dueBy) {
        this.id = id;
        this.status = status;
        this.outcome = outcome;
        this.taskType = taskType;
        this.project = project;
        this.owner = owner;
        this.location = location;
        this.assignees = assignees;
        this.dueBy = dueBy;
    }

    public TaskEvent id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public TaskEvent status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public TaskEvent outcome(@Nullable OutcomeEnum outcome) {
        this.outcome = JsonNullable.of((Object)((Object)outcome));
        return this;
    }

    @Nullable
    @JsonIgnore
    public OutcomeEnum getOutcome() {
        return (OutcomeEnum)((Object)this.outcome.orElse(null));
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OutcomeEnum> getOutcome_JsonNullable() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    public void setOutcome_JsonNullable(JsonNullable<OutcomeEnum> outcome) {
        this.outcome = outcome;
    }

    public void setOutcome(@Nullable OutcomeEnum outcome) {
        this.outcome = JsonNullable.of((Object)((Object)outcome));
    }

    public TaskEvent taskType(@Nonnull TaskEventTaskType taskType) {
        this.taskType = taskType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="taskType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TaskEventTaskType getTaskType() {
        return this.taskType;
    }

    @JsonProperty(value="taskType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaskType(@Nonnull TaskEventTaskType taskType) {
        this.taskType = taskType;
    }

    public TaskEvent project(@Nullable ObjectId project) {
        this.project = project;
        return this;
    }

    @Nullable
    @JsonProperty(value="project")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObjectId getProject() {
        return this.project;
    }

    @JsonProperty(value="project")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProject(@Nullable ObjectId project) {
        this.project = project;
    }

    public TaskEvent owner(@Nullable ObjectId owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObjectId getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(@Nullable ObjectId owner) {
        this.owner = owner;
    }

    public TaskEvent location(@Nullable ObjectId location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObjectId getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(@Nullable ObjectId location) {
        this.location = location;
    }

    public TaskEvent assignees(@Nonnull List<TaskEventAssignees> assignees) {
        this.assignees = assignees;
        return this;
    }

    public TaskEvent addAssigneesItem(TaskEventAssignees assigneesItem) {
        if (this.assignees == null) {
            this.assignees = new ArrayList<TaskEventAssignees>();
        }
        this.assignees.add(assigneesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TaskEventAssignees> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssignees(@Nonnull List<TaskEventAssignees> assignees) {
        this.assignees = assignees;
    }

    public TaskEvent dueBy(@Nullable DateTime dueBy) {
        this.dueBy = dueBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="dueBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DateTime getDueBy() {
        return this.dueBy;
    }

    @JsonProperty(value="dueBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDueBy(@Nullable DateTime dueBy) {
        this.dueBy = dueBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskEvent taskEvent = (TaskEvent)o;
        return Objects.equals(this.id, taskEvent.id) && Objects.equals((Object)this.status, (Object)taskEvent.status) && TaskEvent.equalsNullable(this.outcome, taskEvent.outcome) && Objects.equals(this.taskType, taskEvent.taskType) && Objects.equals(this.project, taskEvent.project) && Objects.equals(this.owner, taskEvent.owner) && Objects.equals(this.location, taskEvent.location) && Objects.equals(this.assignees, taskEvent.assignees) && Objects.equals(this.dueBy, taskEvent.dueBy);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, TaskEvent.hashCodeNullable(this.outcome), this.taskType, this.project, this.owner, this.location, this.assignees, this.dueBy});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("    taskType: ").append(this.toIndentedString(this.taskType)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("    dueBy: ").append(this.toIndentedString(this.dueBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        CREATED("created"),
        IN_PROGRESS("inProgress"),
        FINISHED("finished"),
        SKIPPED("skipped"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OutcomeEnum {
        DONE("done"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        NEGOTIATED("negotiated"),
        DISCARDED("discarded"),
        RETRIED("retried"),
        CANCELLED("cancelled");

        private String value;

        private OutcomeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OutcomeEnum fromValue(String value) {
            for (OutcomeEnum b : OutcomeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

