/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rws.lt.lc.publicapi.sdk.model.LanguageRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "role", "type", "language", "targetLanguages", "path"})
@JsonTypeName(value="source-file-request")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SourceFileRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nonnull
    private RoleEnum role;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @Nonnull
    private LanguageRequest language;
    public static final String JSON_PROPERTY_TARGET_LANGUAGES = "targetLanguages";
    @Nullable
    private List<LanguageRequest> targetLanguages;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private List<String> path;

    public SourceFileRequest() {
    }

    @JsonCreator
    public SourceFileRequest(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="role", required=true) RoleEnum role, @JsonProperty(value="type", required=true) TypeEnum type, @JsonProperty(value="language", required=true) LanguageRequest language, @JsonProperty(value="targetLanguages") List<LanguageRequest> targetLanguages, @JsonProperty(value="path") List<String> path) {
        this.name = name;
        this.role = role;
        this.type = type;
        this.language = language;
        this.targetLanguages = targetLanguages;
        this.path = path;
    }

    public SourceFileRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SourceFileRequest role(@Nonnull RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(@Nonnull RoleEnum role) {
        this.role = role;
    }

    public SourceFileRequest type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public SourceFileRequest language(@Nonnull LanguageRequest language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LanguageRequest getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguage(@Nonnull LanguageRequest language) {
        this.language = language;
    }

    public SourceFileRequest targetLanguages(@Nullable List<LanguageRequest> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public SourceFileRequest addTargetLanguagesItem(LanguageRequest targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<LanguageRequest>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="targetLanguages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LanguageRequest> getTargetLanguages() {
        return this.targetLanguages;
    }

    @JsonProperty(value="targetLanguages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetLanguages(@Nullable List<LanguageRequest> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public SourceFileRequest path(@Nullable List<String> path) {
        this.path = path;
        return this;
    }

    public SourceFileRequest addPathItem(String pathItem) {
        if (this.path == null) {
            this.path = new ArrayList<String>();
        }
        this.path.add(pathItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable List<String> path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceFileRequest sourceFileRequest = (SourceFileRequest)o;
        return Objects.equals(this.name, sourceFileRequest.name) && Objects.equals((Object)this.role, (Object)sourceFileRequest.role) && Objects.equals((Object)this.type, (Object)sourceFileRequest.type) && Objects.equals(this.language, sourceFileRequest.language) && Objects.equals(this.targetLanguages, sourceFileRequest.targetLanguages) && Objects.equals(this.path, sourceFileRequest.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.role, this.type, this.language, this.targetLanguages, this.path});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceFileRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        TRANSLATABLE("translatable"),
        REFERENCE("reference"),
        UNKNOWN("unknown");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        NATIVE("native"),
        BCM("bcm"),
        SDLXLIFF("sdlxliff");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

