/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.rws.lt.lc.publicapi.sdk.model.FileRole;
import com.rws.lt.lc.publicapi.sdk.model.Language;
import com.rws.lt.lc.publicapi.sdk.model.SourceFileVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "name", "role", "language", "versions", "targetLanguages", "path", "totalWords"})
@JsonTypeName(value="source-file")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SourceFile {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_ROLE = "role";
    private JsonNullable<FileRole> role = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @Nullable
    private Language language;
    public static final String JSON_PROPERTY_VERSIONS = "versions";
    @Nullable
    private List<SourceFileVersion> versions;
    public static final String JSON_PROPERTY_TARGET_LANGUAGES = "targetLanguages";
    @Nullable
    private List<Language> targetLanguages;
    public static final String JSON_PROPERTY_PATH = "path";
    @Nullable
    private List<String> path;
    public static final String JSON_PROPERTY_TOTAL_WORDS = "totalWords";
    @Nullable
    private Integer totalWords;

    public SourceFile() {
    }

    @JsonCreator
    public SourceFile(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="name") String name, @JsonProperty(value="role") JsonNullable<FileRole> role, @JsonProperty(value="language") Language language, @JsonProperty(value="versions") List<SourceFileVersion> versions, @JsonProperty(value="targetLanguages") List<Language> targetLanguages, @JsonProperty(value="path") List<String> path, @JsonProperty(value="totalWords") Integer totalWords) {
        this.id = id;
        this.name = name;
        this.role = role;
        this.language = language;
        this.versions = versions;
        this.targetLanguages = targetLanguages;
        this.path = path;
        this.totalWords = totalWords;
    }

    public SourceFile id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public SourceFile name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public SourceFile role(@Nullable FileRole role) {
        this.role = JsonNullable.of((Object)((Object)role));
        return this;
    }

    @Nullable
    @JsonIgnore
    public FileRole getRole() {
        return (FileRole)((Object)this.role.orElse(null));
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<FileRole> getRole_JsonNullable() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole_JsonNullable(JsonNullable<FileRole> role) {
        this.role = role;
    }

    public void setRole(@Nullable FileRole role) {
        this.role = JsonNullable.of((Object)((Object)role));
    }

    public SourceFile language(@Nullable Language language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Language getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(@Nullable Language language) {
        this.language = language;
    }

    public SourceFile versions(@Nullable List<SourceFileVersion> versions) {
        this.versions = versions;
        return this;
    }

    public SourceFile addVersionsItem(SourceFileVersion versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<SourceFileVersion>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="versions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SourceFileVersion> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersions(@Nullable List<SourceFileVersion> versions) {
        this.versions = versions;
    }

    public SourceFile targetLanguages(@Nullable List<Language> targetLanguages) {
        this.targetLanguages = targetLanguages;
        return this;
    }

    public SourceFile addTargetLanguagesItem(Language targetLanguagesItem) {
        if (this.targetLanguages == null) {
            this.targetLanguages = new ArrayList<Language>();
        }
        this.targetLanguages.add(targetLanguagesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="targetLanguages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Language> getTargetLanguages() {
        return this.targetLanguages;
    }

    @JsonProperty(value="targetLanguages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTargetLanguages(@Nullable List<Language> targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public SourceFile path(@Nullable List<String> path) {
        this.path = path;
        return this;
    }

    public SourceFile addPathItem(String pathItem) {
        if (this.path == null) {
            this.path = new ArrayList<String>();
        }
        this.path.add(pathItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(@Nullable List<String> path) {
        this.path = path;
    }

    public SourceFile totalWords(@Nullable Integer totalWords) {
        this.totalWords = totalWords;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalWords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalWords() {
        return this.totalWords;
    }

    @JsonProperty(value="totalWords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalWords(@Nullable Integer totalWords) {
        this.totalWords = totalWords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceFile sourceFile = (SourceFile)o;
        return Objects.equals(this.id, sourceFile.id) && Objects.equals(this.name, sourceFile.name) && SourceFile.equalsNullable(this.role, sourceFile.role) && Objects.equals(this.language, sourceFile.language) && Objects.equals(this.versions, sourceFile.versions) && Objects.equals(this.targetLanguages, sourceFile.targetLanguages) && Objects.equals(this.path, sourceFile.path) && Objects.equals(this.totalWords, sourceFile.totalWords);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, SourceFile.hashCodeNullable(this.role), this.language, this.versions, this.targetLanguages, this.path, this.totalWords);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceFile {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("    targetLanguages: ").append(this.toIndentedString(this.targetLanguages)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    totalWords: ").append(this.toIndentedString(this.totalWords)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

