/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.rws.lt.lc.publicapi.sdk.model.QuoteAdditionalCost;
import com.rws.lt.lc.publicapi.sdk.model.QuoteLanguageCost;
import com.rws.lt.lc.publicapi.sdk.model.QuoteTranslationCost;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"totalAmount", "currencyCode", "translationCosts", "languageCosts", "additionalCosts", "notes"})
@JsonTypeName(value="quote")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Quote {
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "totalAmount";
    private JsonNullable<BigDecimal> totalAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
    @Nullable
    private String currencyCode;
    public static final String JSON_PROPERTY_TRANSLATION_COSTS = "translationCosts";
    @Nullable
    private List<QuoteTranslationCost> translationCosts;
    public static final String JSON_PROPERTY_LANGUAGE_COSTS = "languageCosts";
    @Nullable
    private List<QuoteLanguageCost> languageCosts;
    public static final String JSON_PROPERTY_ADDITIONAL_COSTS = "additionalCosts";
    @Nullable
    private List<QuoteAdditionalCost> additionalCosts;
    public static final String JSON_PROPERTY_NOTES = "notes";
    @Nullable
    private String notes;

    public Quote() {
    }

    @JsonCreator
    public Quote(@JsonProperty(value="totalAmount") JsonNullable<BigDecimal> totalAmount, @JsonProperty(value="currencyCode") String currencyCode, @JsonProperty(value="translationCosts") List<QuoteTranslationCost> translationCosts, @JsonProperty(value="languageCosts") List<QuoteLanguageCost> languageCosts, @JsonProperty(value="additionalCosts") List<QuoteAdditionalCost> additionalCosts, @JsonProperty(value="notes") String notes) {
        this.totalAmount = totalAmount;
        this.currencyCode = currencyCode;
        this.translationCosts = translationCosts;
        this.languageCosts = languageCosts;
        this.additionalCosts = additionalCosts;
        this.notes = notes;
    }

    public Quote totalAmount(@Nullable BigDecimal totalAmount) {
        this.totalAmount = JsonNullable.of((Object)totalAmount);
        return this;
    }

    @Nullable
    @JsonIgnore
    public BigDecimal getTotalAmount() {
        return (BigDecimal)this.totalAmount.orElse(null);
    }

    @JsonProperty(value="totalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigDecimal> getTotalAmount_JsonNullable() {
        return this.totalAmount;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount_JsonNullable(JsonNullable<BigDecimal> totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAmount(@Nullable BigDecimal totalAmount) {
        this.totalAmount = JsonNullable.of((Object)totalAmount);
    }

    public Quote currencyCode(@Nullable String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonProperty(value="currencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencyCode(@Nullable String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Quote translationCosts(@Nullable List<QuoteTranslationCost> translationCosts) {
        this.translationCosts = translationCosts;
        return this;
    }

    public Quote addTranslationCostsItem(QuoteTranslationCost translationCostsItem) {
        if (this.translationCosts == null) {
            this.translationCosts = new ArrayList<QuoteTranslationCost>();
        }
        this.translationCosts.add(translationCostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="translationCosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QuoteTranslationCost> getTranslationCosts() {
        return this.translationCosts;
    }

    @JsonProperty(value="translationCosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslationCosts(@Nullable List<QuoteTranslationCost> translationCosts) {
        this.translationCosts = translationCosts;
    }

    public Quote languageCosts(@Nullable List<QuoteLanguageCost> languageCosts) {
        this.languageCosts = languageCosts;
        return this;
    }

    public Quote addLanguageCostsItem(QuoteLanguageCost languageCostsItem) {
        if (this.languageCosts == null) {
            this.languageCosts = new ArrayList<QuoteLanguageCost>();
        }
        this.languageCosts.add(languageCostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="languageCosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QuoteLanguageCost> getLanguageCosts() {
        return this.languageCosts;
    }

    @JsonProperty(value="languageCosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguageCosts(@Nullable List<QuoteLanguageCost> languageCosts) {
        this.languageCosts = languageCosts;
    }

    public Quote additionalCosts(@Nullable List<QuoteAdditionalCost> additionalCosts) {
        this.additionalCosts = additionalCosts;
        return this;
    }

    public Quote addAdditionalCostsItem(QuoteAdditionalCost additionalCostsItem) {
        if (this.additionalCosts == null) {
            this.additionalCosts = new ArrayList<QuoteAdditionalCost>();
        }
        this.additionalCosts.add(additionalCostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="additionalCosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<QuoteAdditionalCost> getAdditionalCosts() {
        return this.additionalCosts;
    }

    @JsonProperty(value="additionalCosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalCosts(@Nullable List<QuoteAdditionalCost> additionalCosts) {
        this.additionalCosts = additionalCosts;
    }

    public Quote notes(@Nullable String notes) {
        this.notes = notes;
        return this;
    }

    @Nullable
    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotes(@Nullable String notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quote quote = (Quote)o;
        return Quote.equalsNullable(this.totalAmount, quote.totalAmount) && Objects.equals(this.currencyCode, quote.currencyCode) && Objects.equals(this.translationCosts, quote.translationCosts) && Objects.equals(this.languageCosts, quote.languageCosts) && Objects.equals(this.additionalCosts, quote.additionalCosts) && Objects.equals(this.notes, quote.notes);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(Quote.hashCodeNullable(this.totalAmount), this.currencyCode, this.translationCosts, this.languageCosts, this.additionalCosts, this.notes);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Quote {\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    translationCosts: ").append(this.toIndentedString(this.translationCosts)).append("\n");
        sb.append("    languageCosts: ").append(this.toIndentedString(this.languageCosts)).append("\n");
        sb.append("    additionalCosts: ").append(this.toIndentedString(this.additionalCosts)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

