/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.rws.lt.lc.publicapi.sdk.model.ObjectId;
import com.rws.lt.lc.publicapi.sdk.model.TaskConfigurationScope;
import com.rws.lt.lc.publicapi.sdk.model.WorkflowTaskAssignee;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"taskTemplate", "scope", "assignees", "isSkipped", "dueBy"})
@JsonTypeName(value="project-plan-task-configuration")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectPlanTaskConfiguration {
    public static final String JSON_PROPERTY_TASK_TEMPLATE = "taskTemplate";
    @Nonnull
    private ObjectId taskTemplate;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    @Nonnull
    private TaskConfigurationScope scope;
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    @Nullable
    private List<WorkflowTaskAssignee> assignees;
    public static final String JSON_PROPERTY_IS_SKIPPED = "isSkipped";
    private JsonNullable<Boolean> isSkipped = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DUE_BY = "dueBy";
    private JsonNullable<DateTime> dueBy = JsonNullable.undefined();

    public ProjectPlanTaskConfiguration() {
    }

    @JsonCreator
    public ProjectPlanTaskConfiguration(@JsonProperty(value="taskTemplate", required=true) ObjectId taskTemplate, @JsonProperty(value="scope", required=true) TaskConfigurationScope scope, @JsonProperty(value="assignees") List<WorkflowTaskAssignee> assignees, @JsonProperty(value="isSkipped") JsonNullable<Boolean> isSkipped, @JsonProperty(value="dueBy") JsonNullable<DateTime> dueBy) {
        this.taskTemplate = taskTemplate;
        this.scope = scope;
        this.assignees = assignees;
        this.isSkipped = isSkipped;
        this.dueBy = dueBy;
    }

    public ProjectPlanTaskConfiguration taskTemplate(@Nonnull ObjectId taskTemplate) {
        this.taskTemplate = taskTemplate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="taskTemplate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ObjectId getTaskTemplate() {
        return this.taskTemplate;
    }

    @JsonProperty(value="taskTemplate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaskTemplate(@Nonnull ObjectId taskTemplate) {
        this.taskTemplate = taskTemplate;
    }

    public ProjectPlanTaskConfiguration scope(@Nonnull TaskConfigurationScope scope) {
        this.scope = scope;
        return this;
    }

    @Nonnull
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TaskConfigurationScope getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScope(@Nonnull TaskConfigurationScope scope) {
        this.scope = scope;
    }

    public ProjectPlanTaskConfiguration assignees(@Nullable List<WorkflowTaskAssignee> assignees) {
        this.assignees = assignees;
        return this;
    }

    public ProjectPlanTaskConfiguration addAssigneesItem(WorkflowTaskAssignee assigneesItem) {
        if (this.assignees == null) {
            this.assignees = new ArrayList<WorkflowTaskAssignee>();
        }
        this.assignees.add(assigneesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WorkflowTaskAssignee> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignees(@Nullable List<WorkflowTaskAssignee> assignees) {
        this.assignees = assignees;
    }

    public ProjectPlanTaskConfiguration isSkipped(@Nullable Boolean isSkipped) {
        this.isSkipped = JsonNullable.of((Object)isSkipped);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Boolean getIsSkipped() {
        return (Boolean)this.isSkipped.orElse(null);
    }

    @JsonProperty(value="isSkipped")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Boolean> getIsSkipped_JsonNullable() {
        return this.isSkipped;
    }

    @JsonProperty(value="isSkipped")
    public void setIsSkipped_JsonNullable(JsonNullable<Boolean> isSkipped) {
        this.isSkipped = isSkipped;
    }

    public void setIsSkipped(@Nullable Boolean isSkipped) {
        this.isSkipped = JsonNullable.of((Object)isSkipped);
    }

    public ProjectPlanTaskConfiguration dueBy(@Nullable DateTime dueBy) {
        this.dueBy = JsonNullable.of((Object)dueBy);
        return this;
    }

    @Nullable
    @JsonIgnore
    public DateTime getDueBy() {
        return (DateTime)this.dueBy.orElse(null);
    }

    @JsonProperty(value="dueBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DateTime> getDueBy_JsonNullable() {
        return this.dueBy;
    }

    @JsonProperty(value="dueBy")
    public void setDueBy_JsonNullable(JsonNullable<DateTime> dueBy) {
        this.dueBy = dueBy;
    }

    public void setDueBy(@Nullable DateTime dueBy) {
        this.dueBy = JsonNullable.of((Object)dueBy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPlanTaskConfiguration projectPlanTaskConfiguration = (ProjectPlanTaskConfiguration)o;
        return Objects.equals(this.taskTemplate, projectPlanTaskConfiguration.taskTemplate) && Objects.equals(this.scope, projectPlanTaskConfiguration.scope) && Objects.equals(this.assignees, projectPlanTaskConfiguration.assignees) && ProjectPlanTaskConfiguration.equalsNullable(this.isSkipped, projectPlanTaskConfiguration.isSkipped) && ProjectPlanTaskConfiguration.equalsNullable(this.dueBy, projectPlanTaskConfiguration.dueBy);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.taskTemplate, this.scope, this.assignees, ProjectPlanTaskConfiguration.hashCodeNullable(this.isSkipped), ProjectPlanTaskConfiguration.hashCodeNullable(this.dueBy));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectPlanTaskConfiguration {\n");
        sb.append("    taskTemplate: ").append(this.toIndentedString(this.taskTemplate)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("    isSkipped: ").append(this.toIndentedString(this.isSkipped)).append("\n");
        sb.append("    dueBy: ").append(this.toIndentedString(this.dueBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

