/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rws.lt.lc.publicapi.sdk.model.ObjectId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"id", "action", "projects"})
@JsonTypeName(value="project-group-event")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectGroupEvent {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_ACTION = "action";
    @Nonnull
    private ActionEnum action;
    public static final String JSON_PROPERTY_PROJECTS = "projects";
    @Nonnull
    private List<ObjectId> projects;

    public ProjectGroupEvent() {
    }

    @JsonCreator
    public ProjectGroupEvent(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="action", required=true) ActionEnum action, @JsonProperty(value="projects", required=true) List<ObjectId> projects) {
        this.id = id;
        this.action = action;
        this.projects = projects;
    }

    public ProjectGroupEvent id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public ProjectGroupEvent action(@Nonnull ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nonnull
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ActionEnum getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAction(@Nonnull ActionEnum action) {
        this.action = action;
    }

    public ProjectGroupEvent projects(@Nonnull List<ObjectId> projects) {
        this.projects = projects;
        return this;
    }

    public ProjectGroupEvent addProjectsItem(ObjectId projectsItem) {
        if (this.projects == null) {
            this.projects = new ArrayList<ObjectId>();
        }
        this.projects.add(projectsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="projects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ObjectId> getProjects() {
        return this.projects;
    }

    @JsonProperty(value="projects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProjects(@Nonnull List<ObjectId> projects) {
        this.projects = projects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectGroupEvent projectGroupEvent = (ProjectGroupEvent)o;
        return Objects.equals(this.id, projectGroupEvent.id) && Objects.equals((Object)this.action, (Object)projectGroupEvent.action) && Objects.equals(this.projects, projectGroupEvent.projects);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.action, this.projects});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectGroupEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        ATTACH("ATTACH"),
        DETACH("DETACH");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

