/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.exception;

import com.rws.lt.lc.publicapi.sdk.exception.ApiConnectionException;
import com.rws.lt.lc.publicapi.sdk.exception.ApiErrorException;
import com.rws.lt.lc.publicapi.sdk.exception.ApiErrorResponse;
import com.rws.lt.lc.publicapi.sdk.exception.ApiForbiddenException;
import com.rws.lt.lc.publicapi.sdk.exception.ApiUnauthorizedException;
import com.rws.lt.lc.publicapi.sdk.exception.ResponseObjectMapper;
import feign.Request;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;

public class CustomErrorDecoder
implements ErrorDecoder {
    private final ErrorDecoder errorDecoder = new ErrorDecoder.Default();

    public Exception decode(String methodKey, Response response) {
        switch (response.status()) {
            case 401: {
                return this.buildApiUnauthorizedException(response);
            }
            case 403: {
                return this.buildApiForbiddenException(response);
            }
            case 408: {
                Exception exception = this.errorDecoder.decode(methodKey, response);
                return this.buildApiConnectionException(response, exception);
            }
            case 500: {
                return this.buildApiErrorException(response);
            }
        }
        return this.errorDecoder.decode(methodKey, response);
    }

    private Exception buildApiErrorException(Response response) {
        String method = response.request().requestTemplate().method();
        String url = response.request().url();
        String result = null;
        try {
            result = Util.toString((Reader)response.body().asReader());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResponseObjectMapper responseObjectMapper = new ResponseObjectMapper();
        ApiErrorResponse apiErrorResponse = responseObjectMapper.readValue(result);
        return new ApiErrorException(apiErrorResponse, 500, url, Request.HttpMethod.valueOf((String)method), result);
    }

    private Exception buildApiUnauthorizedException(Response response) {
        String url = response.request().url();
        String method = response.request().requestTemplate().method();
        return new ApiUnauthorizedException(url, Request.HttpMethod.valueOf((String)method), response.status(), response.toString());
    }

    private Exception buildApiForbiddenException(Response response) {
        String url = response.request().url();
        String method = response.request().requestTemplate().method();
        return new ApiForbiddenException(url, Request.HttpMethod.valueOf((String)method), response.status(), response.toString());
    }

    private Exception buildApiConnectionException(Response response, Exception ex) {
        String url = response.request().url();
        String method = response.request().requestTemplate().method();
        return new ApiConnectionException(url, Request.HttpMethod.valueOf((String)method), ex);
    }
}

