/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.context;

import com.rws.lt.lc.publicapi.sdk.auth.ServiceCredentials;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCContext
implements AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LCContext.class);
    private static final ThreadLocal<Map> CONTEXT = new ThreadLocal<Map>(){

        @Override
        protected Map initialValue() {
            return new HashMap();
        }
    };

    private LCContext(ServiceCredentials serviceCredentials) {
        Map localMap = CONTEXT.get();
        localMap.put("serviceCredentials", serviceCredentials);
        localMap.put("tenantId", serviceCredentials.getTenantId());
    }

    private LCContext(ServiceCredentials serviceCredentials, @Nullable String traceId) {
        Map localMap = CONTEXT.get();
        localMap.put("serviceCredentials", serviceCredentials);
        localMap.put("tenantId", serviceCredentials.getTenantId());
        Optional.ofNullable(traceId).ifPresent(tid -> localMap.put("traceId", tid));
    }

    private LCContext(@Nullable String tenantId, @Nullable String traceId) {
        Map localMap = CONTEXT.get();
        Optional.ofNullable(tenantId).ifPresent(tid -> localMap.put("tenantId", tid));
        Optional.ofNullable(traceId).ifPresent(tid -> localMap.put("traceId", tid));
    }

    public static Object getFromLCContext(Object key) {
        Map localMap = CONTEXT.get();
        return localMap.get(key);
    }

    public static Boolean containsValueForKey(Object key) {
        Map localMap = CONTEXT.get();
        return localMap.containsKey(key) && localMap.get(key) != null;
    }

    public static void executeInScope(Runnable runnable, String tenantId) {
        try (LCContext ignored = new LCContext(tenantId, null);){
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    public static void executeInScope(Runnable runnable, String tenantId, String traceId) {
        try (LCContext ignored = new LCContext(tenantId, traceId);){
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    public static void executeInScope(Runnable runnable, ServiceCredentials serviceCredentials) {
        try (LCContext ignored = new LCContext(new ServiceCredentials(serviceCredentials.getClientId(), serviceCredentials.getClientSecret(), serviceCredentials.getTenantId()));){
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    public static void executeInScope(Runnable runnable, ServiceCredentials serviceCredentials, String traceId) {
        try (LCContext ignored = new LCContext(new ServiceCredentials(serviceCredentials.getClientId(), serviceCredentials.getClientSecret(), serviceCredentials.getTenantId()), traceId);){
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeInScope(Supplier<T> supplier, String tenantId) {
        try (LCContext ignored = new LCContext(tenantId, null);){
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeInScope(Supplier<T> supplier, String tenantId, String traceId) {
        try (LCContext ignored = new LCContext(tenantId, traceId);){
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeInScope(Supplier<T> supplier, ServiceCredentials serviceCredentials) {
        try (LCContext ignored = new LCContext(new ServiceCredentials(serviceCredentials.getClientId(), serviceCredentials.getClientSecret(), serviceCredentials.getTenantId()));){
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeInScope(Supplier<T> supplier, ServiceCredentials serviceCredentials, String traceId) {
        try (LCContext ignored = new LCContext(new ServiceCredentials(serviceCredentials.getClientId(), serviceCredentials.getClientSecret(), serviceCredentials.getTenantId()), traceId);){
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            LOGGER.error("Execution failed!", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() {
        CONTEXT.remove();
    }
}

